/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);

    public static InputStream getResourceInputStream(Class clazz, String path) {
        logger.debug("load input stream by class {}, path: {}", (Object)clazz.getName(), (Object)path);
        return clazz.getResourceAsStream(path);
    }

    public static InputStream getResourceInputStream(ClassLoader classLoader, String path) {
        logger.debug("load input stream by classloader {}, path: {}", (Object)classLoader, (Object)path);
        return classLoader.getResourceAsStream(path);
    }

    public static FileInputStream getResourceFileInputStream(ClassLoader classLoader, String path) throws URISyntaxException, FileNotFoundException {
        logger.debug("load input stream by classloader {}, path: {}", (Object)classLoader, (Object)path);
        URL url = classLoader.getResource(path);
        if (url != null) {
            return new FileInputStream(new File(url.toURI()));
        }
        return null;
    }

    public static FileInputStream getFileInputStream(String path) throws FileNotFoundException {
        logger.debug("load input stream by file path {}", (Object)path);
        return new FileInputStream(path);
    }

    public static DataInputStream getResourceDataInputStream(String path) throws FileNotFoundException {
        logger.debug("load input stream by file path {}", (Object)path);
        return new DataInputStream(FileUtil.getFileInputStream(path));
    }

    public static FileReader getFileReader(String path) throws FileNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug("load input stream by file path {}", (Object)path);
        }
        return new FileReader(path);
    }

    public static BufferedInputStream getBufferedInputStream(String path) throws FileNotFoundException {
        return new BufferedInputStream(FileUtil.getFileInputStream(path));
    }

    public static BufferedReader getBufferedReader(String path) throws FileNotFoundException {
        return new BufferedReader(FileUtil.getFileReader(path));
    }

    public static byte[] getFileBytes(String path) throws IOException {
        try (BufferedInputStream bis = FileUtil.getBufferedInputStream(path);){
            byte[] content = new byte[bis.available()];
            int length = bis.read(content);
            if (logger.isDebugEnabled()) {
                logger.debug("read file length: {}", (Object)length);
            }
            byte[] byArray = content;
            return byArray;
        }
    }

    public static String getProjectClassPath() {
        return FileUtil.class.getResource("/").getPath();
    }

    public static String getProjectPath() {
        return System.getProperty("user.dir");
    }

    public static String saveToTempDir(byte[] bytes, String contentType) throws IOException {
        String path = System.getProperty("java.io.tmpdir").concat(String.valueOf(System.currentTimeMillis())).concat(".").concat(FileUtil.analyseImageTail(contentType));
        File file = new File(path);
        boolean success = file.createNewFile();
        if (!success) {
            logger.error("cannot create new file at: {}", (Object)System.getProperty("java.io.tmpdir"));
            return null;
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(bytes);
        }
        return path;
    }

    public static void saveFileTo(byte[] bytes, String fileTo) throws IOException {
        boolean success;
        File file = new File(fileTo);
        if (!file.exists() && !(success = file.createNewFile())) {
            throw new RuntimeException(String.format("cannot create new file at: %s", fileTo));
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(bytes);
        }
    }

    private static String analyseImageTail(String contentType) {
        String[] eles = contentType.split("/");
        return eles.length > 1 ? eles[1] : eles[0];
    }

    public static void copyFile(String from, String to) throws IOException {
        try (FileInputStream fis = new FileInputStream(from);
             FileOutputStream fos = new FileOutputStream(to);
             FileChannel fci = fis.getChannel();
             FileChannel fco = fos.getChannel();){
            fci.transferTo(0L, fci.size(), fco);
        }
    }

    public static String getMimeType(String path) throws IOException {
        try (BufferedInputStream bis = FileUtil.getBufferedInputStream(path);){
            String mineType = URLConnection.guessContentTypeFromStream(bis);
            if (mineType == null) {
                String string = "application/octet-stream";
                return string;
            }
            String string = mineType;
            return string;
        }
    }

    public static Path createTempFile(String prefix, String suffix) throws IOException {
        return Files.createTempFile(prefix, suffix, new FileAttribute[0]);
    }

    public static Path copyInputStreamToTempFile(InputStream in, String prefix, String suffix) throws IOException {
        Path tmp = FileUtil.createTempFile(prefix, suffix);
        Files.copy(in, tmp, StandardCopyOption.REPLACE_EXISTING);
        return tmp;
    }

    public static String appendFilePath(String original, String append) {
        if (original.endsWith(File.separator)) {
            return original + append;
        }
        return original + File.separator + append;
    }

    public static boolean initFile(String file) throws IOException {
        return FileUtil.initFile(new File(file));
    }

    public static boolean initFile(File file) throws IOException {
        if (!file.exists()) {
            if (!FileUtil.initDirectory(file.getParentFile())) {
                return false;
            }
            return file.createNewFile();
        }
        return true;
    }

    public static boolean initDirectory(File file) {
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }
}

