/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.io.crypto.helper;

import cn.t.util.common.StringUtil;
import cn.t.util.io.FileUtil;
import cn.t.util.io.crypto.Context;
import cn.t.util.io.crypto.entity.PersistDataResult;
import cn.t.util.io.crypto.entity.ResourceIndex;
import cn.t.util.io.crypto.exception.InitRepositoryException;
import cn.t.util.io.crypto.helper.FileDataHelper;
import cn.t.util.io.crypto.helper.FileIndexHelper;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryHelper {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryHelper.class);
    private Context context;
    private FileIndexHelper fileIndexHelper;
    private FileDataHelper fileDataHelper;

    public String completeRepositoryPath(String target) {
        if (StringUtil.isEmpty((String)target)) {
            target = System.getProperty("user.dir");
            logger.info("specified repository path is empty, use current directory instead: {}", (Object)target);
        }
        return FileUtil.appendFilePath(target, this.context.getRepositoryConfiguration().getRepositoryDirectoryName());
    }

    public void initRepository() throws IOException {
        if (!this.context.getRuntimeConfiguration().getRepositoryDirectory().exists()) {
            boolean success = this.context.getRuntimeConfiguration().getRepositoryDirectory().mkdirs();
            if (!success) {
                throw new InitRepositoryException("\u521d\u59cb\u5316\u4ed3\u5e93\u5931\u8d25");
            }
            this.doInitRepository();
        }
    }

    public void persistData(String resourceKey, File original) throws IOException {
        byte[] resourceKeyBytes = resourceKey.getBytes();
        int index = this.fileIndexHelper.queryResourceIndex(resourceKeyBytes);
        String indexPath = FileUtil.appendFilePath(this.context.getRuntimeConfiguration().getIndexDirectory().getAbsolutePath(), String.valueOf(index));
        try (FileChannel indexChannel = FileChannel.open(Paths.get(indexPath, new String[0]), StandardOpenOption.READ, StandardOpenOption.WRITE);){
            ResourceIndex resourceIndex = this.fileIndexHelper.queryResourceIndex(indexChannel, resourceKeyBytes);
            if (resourceIndex != null) {
                logger.warn("specified resource already exists, ignore persist");
                return;
            }
            byte chunkIndex = this.fileIndexHelper.queryChunkIndex(indexChannel);
            PersistDataResult persistDataResult = this.fileDataHelper.encryptAndPersistData(original, index, chunkIndex);
            this.fileIndexHelper.persistFileIndex(indexChannel, resourceKeyBytes, persistDataResult.getDataPath(), persistDataResult.getDataLength(), persistDataResult.getStartIndex(), persistDataResult.getEndIndex());
        }
    }

    public void recoverData(String resourceKey, File to) throws IOException {
        byte[] resourceKeyBytes = resourceKey.getBytes();
        int index = this.fileIndexHelper.queryResourceIndex(resourceKeyBytes);
        String indexPath = FileUtil.appendFilePath(this.context.getRuntimeConfiguration().getIndexDirectory().getAbsolutePath(), String.valueOf(index));
        try (FileChannel indexChannel = FileChannel.open(Paths.get(indexPath, new String[0]), StandardOpenOption.READ, StandardOpenOption.WRITE);){
            ResourceIndex resourceIndex = this.fileIndexHelper.queryResourceIndex(indexChannel, resourceKeyBytes);
            if (resourceIndex != null) {
                if (!FileUtil.initDirectory(to)) {
                    logger.error("\u521d\u59cb\u5316\u76ee\u5f55\u5931\u8d25: {}", (Object)to.getAbsolutePath());
                    return;
                }
                String dataStorageDirectoryPath = FileUtil.appendFilePath(this.context.getRuntimeConfiguration().getDataDirectory().getAbsolutePath(), String.valueOf(index));
                byte[] dataPaths = resourceIndex.getDataPath();
                if (dataPaths != null && dataPaths.length > 0) {
                    logger.info("\u5373\u5c06\u8fd8\u539f\u8d44\u6e90: {}, \u521b\u5efa\u4e8e: {}", (Object)resourceKey, (Object)new Date(resourceIndex.getCrTime()));
                }
            } else {
                logger.warn("specified resource not exists, ignore recover");
            }
        }
    }

    public void doRecoverData(ResourceIndex resourceIndex, int index, File to) {
        String dataStorageDirectoryPath = FileUtil.appendFilePath(this.context.getRuntimeConfiguration().getDataDirectory().getAbsolutePath(), String.valueOf(index));
        byte[] dataPaths = resourceIndex.getDataPath();
        if (dataPaths != null && dataPaths.length > 0) {
            logger.info("\u5373\u5c06\u8fd8\u539f\u8d44\u6e90: {}, \u521b\u5efa\u4e8e: {}", (Object)new String(resourceIndex.getResourceKeyBytes()), (Object)new Date(resourceIndex.getCrTime()));
            long startIndex = resourceIndex.getStartIndex();
            long l = resourceIndex.getEndIndex();
        }
    }

    private void doInitRepository() throws IOException {
        this.initIndexDir(this.context.getRuntimeConfiguration().getIndexDirectory());
        this.initDataDir(this.context.getRuntimeConfiguration().getDataDirectory());
    }

    private void initIndexDir(File indexDirectory) throws IOException {
        if (!FileUtil.initDirectory(indexDirectory)) {
            throw new InitRepositoryException("\u521b\u5efarepository\u7d22\u5f15\u6587\u4ef6\u5939\u5931\u8d25");
        }
        logger.info("\u521d\u59cb\u5316\u7d22\u5f15\u6587\u4ef6\u5939, bucket sie: {}", (Object)this.context.getRepositoryConfiguration().getIndexBucketSize());
        for (int i = 0; i < this.context.getRepositoryConfiguration().getIndexBucketSize(); ++i) {
            String indexBucket = FileUtil.appendFilePath(indexDirectory.getAbsolutePath(), String.valueOf(i));
            if (!FileUtil.initFile(new File(indexBucket))) {
                throw new InitRepositoryException(String.format("\u521b\u5efa\u7b2c%d\u7d22\u5f15\u6587\u4ef6\u5931\u8d25", i + 1));
            }
            try (DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(indexBucket));){
                dataOutputStream.writeByte(0);
                dataOutputStream.flush();
                continue;
            }
        }
    }

    private void initDataDir(File dataDirectory) throws IOException {
        if (!FileUtil.initDirectory(dataDirectory)) {
            throw new InitRepositoryException("\u521b\u5efarepository\u6570\u636e\u6587\u4ef6\u5939\u5931\u8d25");
        }
        for (int i = 0; i < this.context.getRepositoryConfiguration().getIndexBucketSize(); ++i) {
            String indexDataDir = FileUtil.appendFilePath(dataDirectory.getAbsolutePath(), String.valueOf(i));
            if (FileUtil.initDirectory(new File(indexDataDir))) continue;
            throw new InitRepositoryException(String.format("\u521b\u5efa\u7b2c%d\u7d22\u5f15\u6587\u4ef6\u5931\u8d25", i + 1));
        }
    }

    public RepositoryHelper(Context context) {
        this.context = context;
        this.fileIndexHelper = new FileIndexHelper(context);
        this.fileDataHelper = new FileDataHelper(context);
    }
}

