/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.io.crypto;

import cn.t.util.io.FileUtil;
import cn.t.util.io.crypto.Context;
import cn.t.util.io.crypto.config.RepositoryConfiguration;
import cn.t.util.io.crypto.config.RuntimeConfiguration;
import cn.t.util.io.crypto.helper.RepositoryHelper;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDecrypt {
    private static Logger logger = LoggerFactory.getLogger(FileDecrypt.class);
    private RepositoryConfiguration repositoryConfiguration = new RepositoryConfiguration();
    private RuntimeConfiguration runtimeConfiguration = new RuntimeConfiguration();
    private Context context = new Context();
    private RepositoryHelper repositoryHelper;

    public void decrypt(String repositoryStr, String resourceName, String target) throws IOException {
        File repository = new File(repositoryStr);
        if (!repository.exists()) {
            logger.warn("specified repository not exist");
            return;
        }
        File indexDirectory = new File(FileUtil.appendFilePath(repository.getAbsolutePath(), this.context.getRepositoryConfiguration().getIndexDirectoryName()));
        File dataDirectory = new File(FileUtil.appendFilePath(repository.getAbsolutePath(), this.context.getRepositoryConfiguration().getDataDirectoryName()));
        this.context.getRuntimeConfiguration().setRepositoryDirectory(repository);
        this.context.getRuntimeConfiguration().setIndexDirectory(indexDirectory);
        this.context.getRuntimeConfiguration().setDataDirectory(dataDirectory);
        this.repositoryHelper.recoverData(resourceName, new File(target));
    }

    public FileDecrypt() {
        this.context.setRepositoryConfiguration(this.repositoryConfiguration);
        this.context.setRuntimeConfiguration(this.runtimeConfiguration);
        this.repositoryHelper = new RepositoryHelper(this.context);
    }
}

