/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.internationalize;

import cn.t.util.internationalize.EmptyPropertyResourceBundle;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class ResourceBundleControl
extends ResourceBundle.Control {
    private static final List<String> FORMAT_LIST = Collections.unmodifiableList(Collections.singletonList("java.properties"));

    @Override
    public List<String> getFormats(String baseName) {
        return FORMAT_LIST;
    }

    @Override
    public List<Locale> getCandidateLocales(String baseName, Locale locale) {
        return super.getCandidateLocales(baseName, locale);
    }

    @Override
    public Locale getFallbackLocale(String baseName, Locale locale) {
        return super.getFallbackLocale(baseName, locale);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException {
        System.out.println("locale:" + locale);
        if (!format.equals("java.properties")) return null;
        boolean presentLanguage = locale.getLanguage().length() > 0;
        boolean presentCountry = locale.getCountry().length() > 0;
        String baseNameToUse = baseName;
        if (presentLanguage) {
            baseNameToUse = baseNameToUse + "_" + locale.getLanguage();
        }
        if (presentCountry) {
            baseNameToUse = baseNameToUse + "_" + locale.getCountry();
        }
        String resourceName = this.toResourceName(baseNameToUse, "properties");
        try (InputStream stream = this.loadPrivilegedStream(reload, loader, resourceName);){
            if (stream != null) {
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(stream);
                return propertyResourceBundle;
            }
            if (presentCountry && presentLanguage) {
                EmptyPropertyResourceBundle emptyPropertyResourceBundle = new EmptyPropertyResourceBundle();
                return emptyPropertyResourceBundle;
            }
            ResourceBundle resourceBundle = null;
            return resourceBundle;
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private InputStream loadPrivilegedStream(boolean reload, ClassLoader classLoader, String resourceName) throws PrivilegedActionException {
        return AccessController.doPrivileged(() -> {
            InputStream is = null;
            if (reload) {
                URLConnection connection;
                URL url = classLoader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    is = connection.getInputStream();
                }
            } else {
                is = classLoader.getResourceAsStream(resourceName);
            }
            return is;
        });
    }

    @Override
    public long getTimeToLive(String baseName, Locale locale) {
        return super.getTimeToLive(baseName, locale);
    }

    @Override
    public boolean needsReload(String baseName, Locale locale, String format, ClassLoader loader, ResourceBundle bundle, long loadTime) {
        return super.needsReload(baseName, locale, format, loader, bundle, loadTime);
    }

    @Override
    public String toBundleName(String baseName, Locale locale) {
        return super.toBundleName(baseName, locale);
    }
}

