/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.email;

import cn.t.util.email.EmailMessage;
import cn.t.util.email.SenderConfig;
import com.sun.mail.util.MailSSLSocketFactory;
import java.security.GeneralSecurityException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(EmailClientUtil.class);

    public static void sendEmail(final String username, final String password, EmailMessage emailMessage, SenderConfig config) throws GeneralSecurityException {
        Properties properties = System.getProperties();
        properties.setProperty("mail.smtp.host", config.getHost());
        properties.setProperty("mail.smtp.auth", String.valueOf(config.isNeedAuth()));
        if (config.isEnableSsl()) {
            MailSSLSocketFactory sf = new MailSSLSocketFactory();
            sf.setTrustAllHosts(true);
            properties.put("mail.smtp.ssl.enable", "true");
            properties.put("mail.smtp.ssl.socketFactory", sf);
        }
        Session session = Session.getDefaultInstance((Properties)properties, (Authenticator)new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(username));
            message.addRecipients(Message.RecipientType.TO, (Address[])emailMessage.getTarget());
            message.setSubject(emailMessage.getSubject());
            message.setText(emailMessage.getContent());
            Transport.send((Message)message);
            logger.debug("send message successfully");
        }
        catch (MessagingException mex) {
            mex.printStackTrace();
        }
    }
}

