/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.doc.xml;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListIterable
implements Iterable<Node> {
    private NodeList nodeList;

    public NodeListIterable(NodeList nodeList) {
        this.nodeList = nodeList;
    }

    @Override
    public Iterator<Node> iterator() {
        return new NodeIterator();
    }

    private class NodeIterator
    implements Iterator<Node> {
        private Set<String> excludeNodeNames = new HashSet<String>(){
            {
                this.add("#text");
            }
        };
        private int index = 0;
        private int size;
        private Node currentNode;

        private NodeIterator() {
            this.size = NodeListIterable.this.nodeList.getLength();
        }

        @Override
        public boolean hasNext() {
            if (this.index < this.size) {
                while (this.index < this.size) {
                    this.currentNode = NodeListIterable.this.nodeList.item(this.index++);
                    if (this.currentNode == null || !this.validNode(this.currentNode)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public Node next() {
            return this.currentNode;
        }

        private boolean validNode(Node node) {
            try {
                return !this.excludeNodeNames.contains(node.getNodeName());
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

