/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.doc;

import cn.t.util.common.StringUtil;
import cn.t.util.doc.AbstractReadExcelCallBack;
import cn.t.util.doc.ReadExcelCallBack;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static final Logger logger = LoggerFactory.getLogger(ExcelUtil.class);

    public static void readWorkbook(String path, ReadExcelCallBack readExcelCallBack) throws IOException, InvalidFormatException {
        ExcelUtil.readWorkbook(new File(path), readExcelCallBack);
    }

    private static void readWorkbook(File file, ReadExcelCallBack readExcelCallBack) throws IOException, InvalidFormatException {
        ExcelUtil.readSheet(WorkbookFactory.create((InputStream)new FileInputStream(file)), readExcelCallBack);
    }

    private static void readSheet(Workbook workbook, ReadExcelCallBack readExcelCallBack) throws IOException {
        int totalSheet = workbook.getNumberOfSheets();
        for (int i = 0; i < totalSheet; ++i) {
            Sheet currentSheet = workbook.getSheetAt(i);
            readExcelCallBack.readSheet(currentSheet);
            ExcelUtil.readRow(currentSheet, readExcelCallBack);
            readExcelCallBack.readSheetComplete(currentSheet);
        }
        readExcelCallBack.readWorkbookComplete(workbook);
    }

    private static void readRow(Sheet sheet, ReadExcelCallBack readExcelCallBack) {
        int totalRow = sheet.getLastRowNum() + 1;
        for (int i = 0; i < totalRow; ++i) {
            Row currentRow = sheet.getRow(i);
            readExcelCallBack.readRow(currentRow, i);
            if (currentRow == null) continue;
            ExcelUtil.readCell(currentRow, readExcelCallBack);
            readExcelCallBack.readRowComplete(currentRow);
        }
    }

    private static void readCell(Row row, ReadExcelCallBack readExcelCallBack) {
        int totalCell = row.getLastCellNum();
        boolean isFirst = true;
        boolean isLast = totalCell < 2;
        for (int i = 0; i < totalCell; ++i) {
            Cell currentCell = row.getCell(i);
            if (currentCell == null) continue;
            if (isFirst) {
                readExcelCallBack.readFirstCell(currentCell);
                isFirst = false;
            } else {
                isLast = i == totalCell - 1;
            }
            readExcelCallBack.readCell(currentCell, i);
            if (!isLast) continue;
            readExcelCallBack.readLastCell(currentCell);
        }
    }

    public static void clearBlankRows(String sourceExcel, final String targetExcel) throws IOException, InvalidFormatException {
        ExcelUtil.readWorkbook(sourceExcel, (ReadExcelCallBack)new AbstractReadExcelCallBack(){
            private DataFormatter formatter = new DataFormatter();
            private int blankCellCount;
            private List<Integer> rowLIndexToBeRemoved = new ArrayList<Integer>();

            @Override
            public void readRow(Row row, int index) {
                if (logger.isDebugEnabled()) {
                    logger.debug("read row: {}", (Object)index);
                }
                if (row == null) {
                    this.rowLIndexToBeRemoved.add(index);
                }
            }

            @Override
            public void readFirstCell(Cell cell) {
                this.blankCellCount = 0;
            }

            @Override
            public void readCell(Cell cell, int index) {
                if (StringUtil.isEmpty((String)this.formatter.formatCellValue(cell))) {
                    ++this.blankCellCount;
                }
            }

            @Override
            public void readRowComplete(Row row) {
                if (row.getLastCellNum() == this.blankCellCount) {
                    this.rowLIndexToBeRemoved.add(row.getRowNum());
                }
            }

            @Override
            public void readSheetComplete(Sheet sheet) {
                if (logger.isDebugEnabled()) {
                    logger.debug("sheet: {} read complete", (Object)sheet.getSheetName());
                }
                for (int i = this.rowLIndexToBeRemoved.size() - 1; i > -1; --i) {
                    Row row = sheet.getRow(this.rowLIndexToBeRemoved.get(i).intValue());
                    if (row == null) {
                        if (this.rowLIndexToBeRemoved.get(i) >= sheet.getLastRowNum()) continue;
                        sheet.shiftRows(this.rowLIndexToBeRemoved.get(i) + 1, sheet.getLastRowNum(), -1);
                        continue;
                    }
                    try {
                        if (row.getRowNum() < sheet.getLastRowNum()) {
                            sheet.shiftRows(row.getRowNum() + 1, sheet.getLastRowNum(), -1);
                            continue;
                        }
                        sheet.removeRow(row);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.rowLIndexToBeRemoved.clear();
            }

            @Override
            public void readWorkbookComplete(Workbook workbook) throws IOException {
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(targetExcel);
                    workbook.write((OutputStream)fos);
                }
                finally {
                    if (fos != null) {
                        fos.flush();
                        fos.close();
                    }
                    workbook.close();
                }
            }
        });
    }

    public static void printExcel(String path) throws IOException, InvalidFormatException {
        ExcelUtil.readWorkbook(path, (ReadExcelCallBack)new AbstractReadExcelCallBack(){
            private DataFormatter formatter = new DataFormatter();

            @Override
            public void readCell(Cell cell, int index) {
                System.out.print(this.formatter.formatCellValue(cell) + "\t");
            }

            @Override
            public void readLastCell(Cell cell) {
                System.out.println();
            }
        });
    }
}

