package cn.t.util.doc;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

import java.io.IOException;

public interface ReadExcelCallBack {

    /**
     * 读取workbook
     * @param workbook xxx
     */
    void readWorkbook(Workbook workbook);

    /**
     * 读取sheet
     * @param sheet xxx
     */
    void readSheet(Sheet sheet);

    /**
     * 读取行
     * @param row   xxx
     * @param index xxx
     */
    void readRow(Row row, int index);

    /**
     * 读取第一个cell
     * @param cell xxx
     */
    void readFirstCell(Cell cell);

    /**
     * 读取单元格
     * @param cell  xxx
     * @param index xxx
     */
    void readCell(Cell cell, int index);

    /**
     * 读取最后一个cell
     * @param cell xxx
     */
    void readLastCell(Cell cell);

    /**
     * 读取完一个row
     * @param row xxx
     */
    void readRowComplete(Row row);

    /**
     * 读取完一个sheet
     * @param sheet xxx
     */
    void readSheetComplete(Sheet sheet);

    /**
     * 读取完一个workbook
     * @param workbook xxx
     * @throws IOException xxx
     */
    void readWorkbookComplete(Workbook workbook) throws IOException;

}
