package cn.t.util.digital;

import java.nio.ByteOrder;

/**
 * xxx
 */
public final class IntUtil {


    private static final int FF = 0xFF;


    private IntUtil() {
    }

    /**
     * int number to bytes
     * @param value xxx
     * @param order xxx
     * @return xxx
     */
    public static byte[] intToBytes(int value, ByteOrder order) {
        byte[] bytes = new byte[4];
        //大端
        if (ByteOrder.BIG_ENDIAN == order) {
            for (byte i = 0; i < 4; i++) {
                bytes[i] = (byte) (value >> (24 - (i * 8)) & FF);
            }
        } else {
            //小端
            for (byte i = 0; i < 4; i++) {
                bytes[i] = (byte) (value >> (i * 8) & FF);
            }
        }
        return bytes;
    }

    public static int bytesToInt(byte[] source) {
        return bytesToInt(source, 0, ByteOrder.BIG_ENDIAN);
    }

    /**
     * bytes to int
     * @param source xxx
     * @param offset xxx
     * @param order xxx
     * @return xxx
     */
    public static int bytesToInt(byte[] source, int offset, ByteOrder order) {
        int value;
        //大端
        if (ByteOrder.BIG_ENDIAN == order) {
            value = ((source[offset] & 0xFF) << 24)
                | ((source[offset + 1] & 0xFF) << 16)
                | ((source[offset + 2] & 0xFF) << 8)
                | (source[offset + 3] & 0xFF);
        } else {
            //小端
            value = (source[offset] & 0xFF)
                | ((source[offset + 1] & 0xFF) << 8)
                | ((source[offset + 2] & 0xFF) << 16)
                | ((source[offset + 3] & 0xFF) << 24);
        }
        return value;
    }
}
