/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.common.reflect;

import cn.t.util.common.proxy.ProxyCallback;
import cn.t.util.common.proxy.ProxyConfig;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;

public class ProxyUtil {
    public static Object generateCglibProxy(Object target, ProxyConfig config) {
        CglibProxy proxy = new CglibProxy(target, config.getProxyCallback());
        CglibProxyCallbackFilter filter = new CglibProxyCallbackFilter(proxy, config);
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(target.getClass());
        enhancer.setCallbacks(new Callback[]{proxy, NoOp.INSTANCE});
        enhancer.setCallbackFilter((CallbackFilter)filter);
        return enhancer.create();
    }

    public static Object generateJdkProxy(Object target, ProxyConfig config) {
        JdkProxy jdkProxy = new JdkProxy(target, config);
        return Proxy.newProxyInstance(target.getClass().getClassLoader(), target.getClass().getInterfaces(), (InvocationHandler)jdkProxy);
    }

    private static class JdkProxy
    implements InvocationHandler,
    BaseProxy {
        private Object target;
        private ProxyConfig config;

        private JdkProxy(Object target, ProxyConfig config) {
            this.target = target;
            this.config = config;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            boolean apply = this.apply(method, this.config.getInterceptMethods());
            if (apply) {
                this.config.getProxyCallback().before(this.target, method, args);
            }
            Object result = method.invoke(this.target, args);
            if (apply) {
                this.config.getProxyCallback().after(result);
            }
            return result;
        }
    }

    private static class CglibProxy
    implements MethodInterceptor,
    BaseProxy {
        private Object target;
        private ProxyCallback callback;

        private CglibProxy(Object target, ProxyCallback callback) {
            this.target = target;
            this.callback = callback;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            this.callback.before(obj, method, args);
            Object result = methodProxy.invokeSuper(obj, args);
            this.callback.after(result);
            return result;
        }
    }

    private static class CglibProxyCallbackFilter
    implements CallbackFilter {
        private BaseProxy proxy;
        private ProxyConfig config;

        private CglibProxyCallbackFilter(BaseProxy proxy, ProxyConfig config) {
            this.proxy = proxy;
            this.config = config;
        }

        public int accept(Method method) {
            return this.proxy.apply(method, this.config.getInterceptMethods()) ? 0 : 1;
        }
    }

    private static interface BaseProxy {
        default public boolean apply(Method method, String ... methods) {
            if (methods == null || methods.length == 0) {
                return false;
            }
            String methodName = method.getName();
            for (String m : methods) {
                if (!methodName.equals(m)) continue;
                return true;
            }
            return false;
        }
    }
}

