/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.common.random;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;

public class AlternativeJdkIdGenerator {
    private final Random random;

    public AlternativeJdkIdGenerator() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] seed = new byte[8];
        secureRandom.nextBytes(seed);
        this.random = new Random(new BigInteger(seed).longValue());
    }

    public static void main(String[] args) {
        AlternativeJdkIdGenerator generator = new AlternativeJdkIdGenerator();
        System.out.println(generator.generateId());
    }

    public UUID generateId() {
        byte[] randomBytes = new byte[16];
        this.random.nextBytes(randomBytes);
        long mostSigBits = 0L;
        for (int i = 0; i < 8; ++i) {
            mostSigBits = mostSigBits << 8 | (long)(randomBytes[i] & 0xFF);
        }
        long leastSigBits = 0L;
        for (int i = 8; i < 16; ++i) {
            leastSigBits = leastSigBits << 8 | (long)(randomBytes[i] & 0xFF);
        }
        return new UUID(mostSigBits, leastSigBits);
    }
}

