/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.common.digital;

import java.nio.ByteOrder;

public class ShortUtil {
    public static byte[] shortToBytes(short value, ByteOrder byteOrder) {
        byte[] bytes = new byte[2];
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            bytes[0] = (byte)value;
            bytes[1] = (byte)(value >> 8);
        } else {
            bytes[0] = (byte)(value >> 8);
            bytes[1] = (byte)value;
        }
        return bytes;
    }

    public static short bytesToShort(byte[] bs) {
        return ShortUtil.bytesToShort(bs, ByteOrder.BIG_ENDIAN);
    }

    public static short bytesToShort(byte[] bs, ByteOrder byteOrder) {
        return ShortUtil.bytesToShort(bs, 0, byteOrder);
    }

    public static short bytesToShort(byte[] source, int offset, ByteOrder order) {
        short value = ByteOrder.LITTLE_ENDIAN == order ? (short)(source[offset] & 0xFF | (source[offset + 1] & 0xFF) << 8) : (short)((source[offset] & 0xFF) << 8 | source[offset + 1] & 0xFF);
        return value;
    }
}

