/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.common.digital;

import java.nio.ByteOrder;

public final class IntUtil {
    private static final int FF = 255;

    private IntUtil() {
    }

    public static byte[] intToBytes(int value, ByteOrder order) {
        byte[] bytes = new byte[4];
        if (ByteOrder.BIG_ENDIAN == order) {
            for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
                bytes[i] = (byte)(value >> 24 - i * 8);
            }
        } else {
            for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
                bytes[i] = (byte)(value >> i * 8);
            }
        }
        return bytes;
    }

    public static int[] intToPositiveBytes(int value, ByteOrder order) {
        int[] ints = new int[4];
        if (ByteOrder.BIG_ENDIAN == order) {
            for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
                ints[i] = value >> 24 - i * 8 & 0xFF;
            }
        } else {
            for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
                ints[i] = value >> i * 8 & 0xFF;
            }
        }
        return ints;
    }

    public static int bytesToInt(byte[] source) {
        return IntUtil.bytesToInt(source, 0, ByteOrder.BIG_ENDIAN);
    }

    public static int bytesToInt(byte[] source, int offset, ByteOrder order) {
        int value = ByteOrder.BIG_ENDIAN == order ? (source[offset] & 0xFF) << 24 | (source[offset + 1] & 0xFF) << 16 | (source[offset + 2] & 0xFF) << 8 | source[offset + 3] & 0xFF : source[offset] & 0xFF | (source[offset + 1] & 0xFF) << 8 | (source[offset + 2] & 0xFF) << 16 | (source[offset + 3] & 0xFF) << 24;
        return value;
    }
}

