/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.common.digital;

import cn.t.util.common.digital.CharUtil;

public final class HexUtil {
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private HexUtil() {
    }

    public static int hexToInt(char left, char right) {
        int l = CharUtil.hexAsciiCharToInt(left);
        int r = CharUtil.hexAsciiCharToInt(right);
        return l << 4 | r;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(hex[b >> 4 & 0xF]);
            sb.append(hex[b & 0xF]);
        }
        return sb.toString();
    }

    public static byte[] stringToBytes(String hex) {
        char[] data = hex.toCharArray();
        int len = data.length;
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = HexUtil.toDigit(data[j], j) << 4;
            f |= HexUtil.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static String numberToHexString(byte num) throws IllegalAccessException {
        int units = HexUtil.byteUnits(Byte.TYPE);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < units; ++i) {
            byte current = (byte)(num >> 8 * (units - 1 - i));
            sb.append(hex[current >> 4 & 0xF]);
            sb.append(hex[current & 0xF]);
        }
        return sb.toString();
    }

    public static String numberToHexString(short num) throws IllegalAccessException {
        int units = HexUtil.byteUnits(Short.TYPE);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < units; ++i) {
            byte current = (byte)(num >> 8 * (units - 1 - i));
            sb.append(hex[current >> 4 & 0xF]);
            sb.append(hex[current & 0xF]);
        }
        return sb.toString();
    }

    public static String numberToHexString(char num) throws IllegalAccessException {
        int units = HexUtil.byteUnits(Character.TYPE);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < units; ++i) {
            byte current = (byte)(num >> 8 * (units - 1 - i));
            sb.append(hex[current >> 4 & 0xF]);
            sb.append(hex[current & 0xF]);
        }
        return sb.toString();
    }

    public static String numberToHexString(int num) throws IllegalAccessException {
        int units = HexUtil.byteUnits(Integer.TYPE);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < units; ++i) {
            byte current = (byte)(num >> 8 * (units - 1 - i));
            sb.append(hex[current >> 4 & 0xF]);
            sb.append(hex[current & 0xF]);
        }
        return sb.toString();
    }

    public static String numberToHexString(long num) throws IllegalAccessException {
        int units = HexUtil.byteUnits(Long.TYPE);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < units; ++i) {
            byte current = (byte)(num >> 8 * (units - 1 - i));
            sb.append(hex[current >> 4 & 0xF]);
            sb.append(hex[current & 0xF]);
        }
        return sb.toString();
    }

    private static byte byteUnits(Class<?> numberClass) throws IllegalAccessException {
        if (Byte.TYPE == numberClass || Byte.class == numberClass) {
            return 1;
        }
        if (Short.TYPE == numberClass || Short.class == numberClass) {
            return 2;
        }
        if (Character.TYPE == numberClass || Character.class == numberClass) {
            return 2;
        }
        if (Integer.TYPE == numberClass || Integer.class == numberClass) {
            return 4;
        }
        if (Long.TYPE == numberClass || Long.class == numberClass) {
            return 8;
        }
        throw new IllegalAccessException("class must be primitive: [byte, short, char, int, long]");
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }
}

