/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.common.digital;

public final class BitUtil {
    private BitUtil() {
    }

    public static byte[] toUnsignedBitArray(byte b) {
        return BitUtil.toBitArray(b, false);
    }

    public static byte[] toSignedBitArray(byte b) {
        return BitUtil.toBitArray(b, true);
    }

    private static byte[] toBitArray(byte b, boolean signed) {
        int sign = signed ? -1 : 1;
        byte[] array = new byte[8];
        array[0] = (byte)(b >> 7 & sign);
        for (int i = 1; i < 8; i = (int)((byte)(i + 1))) {
            array[i] = (byte)(b >> 7 - i & 1);
        }
        return array;
    }

    public static String toUnsignedBitStr(byte b) {
        return BitUtil.toBitStr(b, false);
    }

    public static String toSignedBitStr(byte b) {
        return BitUtil.toBitStr(b, true);
    }

    private static String toBitStr(byte b, boolean signed) {
        int sign = signed ? -1 : 1;
        StringBuilder sb = new StringBuilder();
        sb.append(b >> 7 & sign);
        for (int i = 1; i < 8; i = (int)((byte)(i + 1))) {
            sb.append(b >> 7 - i & 1);
        }
        return sb.toString();
    }

    public static byte toByte(String bits) {
        return Byte.valueOf(bits, 2);
    }
}

