/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.common;

public class StringUtil {
    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isAllNumeric(String str) {
        char[] chars = str.toCharArray();
        if (chars.length == 0) {
            return false;
        }
        for (char c : chars) {
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(String str) {
        return str != null && !str.isEmpty();
    }

    public static boolean hasText(CharSequence str) {
        if (!StringUtil.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasText(String str) {
        return str != null && !str.isEmpty() && StringUtil.hasText((CharSequence)str);
    }

    public static boolean containsWhitespace(CharSequence str) {
        if (!StringUtil.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (!StringUtil.hasLength(inString) || !StringUtil.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        int index = inString.indexOf(oldPattern);
        if (index == -1) {
            return inString;
        }
        int capacity = inString.length();
        if (newPattern.length() > oldPattern.length()) {
            capacity += 16;
        }
        StringBuilder sb = new StringBuilder(capacity);
        int pos = 0;
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String removeEmoji(String src) {
        byte count;
        if (!StringUtil.hasLength(src)) {
            return src;
        }
        byte[] bytes = src.getBytes();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; i += count) {
            count = StringUtil.countUTF8CharBytes(bytes[i]);
            if (count < 2) {
                sb.append((char)bytes[i]);
                count = 1;
                continue;
            }
            if (count < 4) {
                sb.append(new String(bytes, i, (int)count));
                continue;
            }
            sb.append("*");
        }
        return sb.toString();
    }

    public static String emojiToUnicode(String src) {
        StringBuilder unicode = new StringBuilder();
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            int codepoint = src.codePointAt(i);
            if (StringUtil.isEmojiCharacter(codepoint)) {
                unicode.append("\\u").append(Integer.toHexString(c));
                continue;
            }
            unicode.append(c);
        }
        return unicode.toString();
    }

    public static String unicodeToEmoji(String src) {
        if (StringUtil.isEmpty(src)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int length = src.length();
        for (int i = 0; i < length; ++i) {
            if (src.charAt(i) == '\\') {
                if (i < length - 5 && (src.charAt(i + 1) == 'u' || src.charAt(i + 1) == 'U')) {
                    try {
                        builder.append((char)Integer.parseInt(src.substring(i + 2, i + 6), 16));
                        i += 5;
                    }
                    catch (NumberFormatException localNumberFormatException) {
                        builder.append(src.charAt(i));
                    }
                    continue;
                }
                builder.append(src.charAt(i));
                continue;
            }
            builder.append(src.charAt(i));
        }
        return builder.toString();
    }

    public static boolean isEmojiCharacter(int codePoint) {
        return codePoint >= 9728 && codePoint <= 10175 || codePoint == 12349 || codePoint == 8265 || codePoint == 8252 || codePoint >= 8192 && codePoint <= 8207 || codePoint >= 8232 && codePoint <= 8239 || codePoint == 8287 || codePoint >= 8293 && codePoint <= 8303 || codePoint >= 8448 && codePoint <= 8527 || codePoint >= 8960 && codePoint <= 9215 || codePoint >= 11008 && codePoint <= 11263 || codePoint >= 10496 && codePoint <= 10623 || codePoint >= 12800 && codePoint <= 13055 || codePoint >= 55296 && codePoint <= 57343 || codePoint >= 57344 && codePoint <= 63743 || codePoint >= 65024 && codePoint <= 65039 || codePoint >= 65536;
    }

    public static byte countUTF8CharBytes(byte b) {
        byte offset;
        for (offset = 0; offset < 8 && (b >> 7 - offset & 1) == 1; offset = (byte)(offset + 1)) {
        }
        return offset;
    }

    public static StringPart partUTF8String(String src) {
        byte numBytes;
        byte[] bytes = src.getBytes();
        StringPart stringPart = new StringPart();
        StringBuilder latinCharactersBuilder = new StringBuilder();
        StringBuilder otherCharactersBuilder = new StringBuilder();
        for (int cursor = 0; cursor < bytes.length; cursor += numBytes) {
            byte buff = bytes[cursor];
            byte offset = StringUtil.countUTF8CharBytes(buff);
            byte by = numBytes = offset == 0 || offset == 1 ? (byte)1 : offset;
            if (numBytes == 1) {
                latinCharactersBuilder.append((char)bytes[cursor]);
                continue;
            }
            byte[] tmp = new byte[numBytes];
            System.arraycopy(bytes, cursor, tmp, 0, numBytes);
            otherCharactersBuilder.append(new String(tmp));
        }
        return stringPart.setLatinCharacters(latinCharactersBuilder.toString().toCharArray()).setOtherCharacters(otherCharactersBuilder.toString().toCharArray());
    }

    public static class StringPart {
        private char[] latinCharacters;
        private char[] otherCharacters;

        public char[] getLatinCharacters() {
            return this.latinCharacters;
        }

        private StringPart setLatinCharacters(char[] latinCharacters) {
            this.latinCharacters = latinCharacters;
            return this;
        }

        public char[] getOtherCharacters() {
            return this.otherCharacters;
        }

        private StringPart setOtherCharacters(char[] otherCharacters) {
            this.otherCharacters = otherCharacters;
            return this;
        }
    }
}

