/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.common;

import cn.t.util.common.Assert;
import cn.t.util.common.proxy.ProxyCallback;
import cn.t.util.common.proxy.ProxyConfig;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;

public class ReflectUtil {
    private static final Map<Class<?>, Method[]> declaredMethodsCache = new ConcurrentHashMap(256);
    private static final Method[] NO_METHODS = new Method[0];

    public static Object generateCglibProxy(Object target, ProxyConfig config) {
        CglibProxy proxy = new CglibProxy(target, config.getProxyCallback());
        CglibProxyCallbackFilter filter = new CglibProxyCallbackFilter(proxy, config);
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(target.getClass());
        enhancer.setCallbacks(new Callback[]{proxy, NoOp.INSTANCE});
        enhancer.setCallbackFilter((CallbackFilter)filter);
        return enhancer.create();
    }

    public static Object generateJdkProxy(Object target, ProxyConfig config) {
        JdkProxy jdkProxy = new JdkProxy(target, config);
        return Proxy.newProxyInstance(target.getClass().getClassLoader(), target.getClass().getInterfaces(), (InvocationHandler)jdkProxy);
    }

    public static Class findTypeParam(Object object, Class<?> parameterizedSuperclass, String typeParamName) {
        Class<?> thisClass;
        Class<?> currentClass = thisClass = object.getClass();
        while (true) {
            if (currentClass.getSuperclass() == parameterizedSuperclass) {
                int typeParamIndex = -1;
                TypeVariable<Class<?>>[] typeParams = currentClass.getSuperclass().getTypeParameters();
                for (int i = 0; i < typeParams.length; ++i) {
                    if (!typeParamName.equals(typeParams[i].getName())) continue;
                    typeParamIndex = i;
                    break;
                }
                if (typeParamIndex < 0) {
                    throw new IllegalStateException("unknown type parameter '" + typeParamName + "': " + parameterizedSuperclass);
                }
                Type genericSuperType = currentClass.getGenericSuperclass();
                if (!(genericSuperType instanceof ParameterizedType)) {
                    return Object.class;
                }
                Type[] actualTypeParams = ((ParameterizedType)genericSuperType).getActualTypeArguments();
                Type actualTypeParam = actualTypeParams[typeParamIndex];
                if (actualTypeParam instanceof ParameterizedType) {
                    actualTypeParam = ((ParameterizedType)actualTypeParam).getRawType();
                }
                if (actualTypeParam instanceof Class) {
                    return (Class)actualTypeParam;
                }
                if (actualTypeParam instanceof GenericArrayType) {
                    Type componentType = ((GenericArrayType)actualTypeParam).getGenericComponentType();
                    if (componentType instanceof ParameterizedType) {
                        componentType = ((ParameterizedType)componentType).getRawType();
                    }
                    if (componentType instanceof Class) {
                        return Array.newInstance((Class)componentType, 0).getClass();
                    }
                }
                if (actualTypeParam instanceof TypeVariable) {
                    TypeVariable v = (TypeVariable)actualTypeParam;
                    currentClass = thisClass;
                    if (!(v.getGenericDeclaration() instanceof Class)) {
                        return Object.class;
                    }
                    parameterizedSuperclass = (Class)v.getGenericDeclaration();
                    typeParamName = v.getName();
                    if (parameterizedSuperclass.isAssignableFrom(thisClass)) continue;
                    return Object.class;
                }
                throw new IllegalStateException("cannot determine the type of the type parameter '" + thisClass + "': " + typeParamName);
            }
            if ((currentClass = currentClass.getSuperclass()) == null) break;
        }
        throw new IllegalStateException("cannot determine the type of the type parameter '" + thisClass + "': " + typeParamName);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull(name, "Method name must not be null");
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : ReflectUtil.getDeclaredMethods(searchType)) {
                if (!name.equals(method.getName()) || paramTypes != null && !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    private static Method[] getDeclaredMethods(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        Method[] result = declaredMethodsCache.get(clazz);
        if (result == null) {
            Method[] declaredMethods = clazz.getDeclaredMethods();
            List<Method> defaultMethods = ReflectUtil.findConcreteMethodsOnInterfaces(clazz);
            if (defaultMethods != null) {
                result = new Method[declaredMethods.length + defaultMethods.size()];
                System.arraycopy(declaredMethods, 0, result, 0, declaredMethods.length);
                int index = declaredMethods.length;
                Iterator<Method> iterator = defaultMethods.iterator();
                while (iterator.hasNext()) {
                    Method defaultMethod;
                    result[index] = defaultMethod = iterator.next();
                    ++index;
                }
            } else {
                result = declaredMethods;
            }
            declaredMethodsCache.put(clazz, result.length == 0 ? NO_METHODS : result);
        }
        return result;
    }

    private static List<Method> findConcreteMethodsOnInterfaces(Class<?> clazz) {
        LinkedList<Method> result = null;
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method ifcMethod : ifc.getMethods()) {
                if (Modifier.isAbstract(ifcMethod.getModifiers())) continue;
                if (result == null) {
                    result = new LinkedList<Method>();
                }
                result.add(ifcMethod);
            }
        }
        return result;
    }

    public static boolean isPublicStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && ReflectUtil.isPublic(modifiers) && ReflectUtil.isFinal(modifiers);
    }

    public static boolean isPublic(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    public static boolean isPublic(int modifiers) {
        return Modifier.isPublic(modifiers);
    }

    public static boolean isFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isFinal(modifiers);
    }

    public static boolean isFinal(int modifiers) {
        return Modifier.isFinal(modifiers);
    }

    private static class JdkProxy
    implements InvocationHandler,
    BaseProxy {
        private Object target;
        private ProxyConfig config;

        private JdkProxy(Object target, ProxyConfig config) {
            this.target = target;
            this.config = config;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            boolean apply = this.apply(method, this.config.getInterceptMethods());
            if (apply) {
                this.config.getProxyCallback().before(this.target, method, args);
            }
            Object result = method.invoke(this.target, args);
            if (apply) {
                this.config.getProxyCallback().after(result);
            }
            return result;
        }
    }

    private static class CglibProxy
    implements MethodInterceptor,
    BaseProxy {
        private Object target;
        private ProxyCallback callback;

        public CglibProxy(Object target, ProxyCallback callback) {
            this.target = target;
            this.callback = callback;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            this.callback.before(obj, method, args);
            Object result = methodProxy.invokeSuper(obj, args);
            this.callback.after(result);
            return result;
        }
    }

    private static class CglibProxyCallbackFilter
    implements CallbackFilter {
        private BaseProxy proxy;
        private ProxyConfig config;

        private CglibProxyCallbackFilter(BaseProxy proxy, ProxyConfig config) {
            this.proxy = proxy;
            this.config = config;
        }

        public int accept(Method method) {
            return this.proxy.apply(method, this.config.getInterceptMethods()) ? 0 : 1;
        }
    }

    private static interface BaseProxy {
        default public boolean apply(Method method, String ... methods) {
            if (methods == null || methods.length == 0) {
                return false;
            }
            String methodName = method.getName();
            for (String m : methods) {
                if (!methodName.equals(m)) continue;
                return true;
            }
            return false;
        }
    }
}

