/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.common;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;

public class GenericUtil {
    public static ClassGeneric getGeneric(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Type type = clazz.getGenericSuperclass();
        return GenericUtil.doGetGeneric(type);
    }

    public static ClassGeneric doGetGeneric(Type type) {
        if (type == null) {
            return null;
        }
        ClassGeneric classGeneric = new ClassGeneric();
        ArrayList<Generic> genericList = new ArrayList<Generic>();
        classGeneric.setGenericList(genericList);
        if (type instanceof ParameterizedType) {
            Type[] types;
            Class superClass;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class && !Object.class.equals((Object)(superClass = (Class)rawType))) {
                TypeVariable<Class<T>>[] superTypeVariables = superClass.getTypeParameters();
                ClassGeneric superClassGeneric = new ClassGeneric();
                ArrayList<Generic> superGenericList = new ArrayList<Generic>();
                superClassGeneric.setGenericList(superGenericList);
                for (TypeVariable superTypeVariable : superTypeVariables) {
                    Generic superGeneric = new Generic();
                    superGeneric.setType(superTypeVariable.getName());
                    superGenericList.add(superGeneric);
                }
                classGeneric.setParent(superClassGeneric);
                Class superSuperClass = superClass.getSuperclass();
                if (!Object.class.equals(superSuperClass)) {
                    Type superSuperType = superClass.getGenericSuperclass();
                    superClassGeneric.setParent(GenericUtil.doGetGeneric(superSuperType));
                }
            }
            for (Type t : types = parameterizedType.getActualTypeArguments()) {
                Generic generic = new Generic();
                if (t instanceof ParameterizedType) {
                    generic.setType(((ParameterizedType)t).getRawType().getTypeName());
                    generic.setEmbedClassGeneric(GenericUtil.doGetGeneric(t));
                } else if (t instanceof TypeVariable) {
                    generic.setType(((TypeVariable)t).getName());
                } else if (t instanceof Class) {
                    generic.setType(((Class)t).getName());
                } else {
                    System.out.println("[warn] run in else");
                }
                genericList.add(generic);
            }
        } else if (type instanceof TypeVariable) {
            Generic generic = new Generic();
            generic.setType(((TypeVariable)type).getName());
            genericList.add(generic);
        } else if (type instanceof Class) {
            Generic generic = new Generic();
            generic.setType(((Class)type).getName());
            genericList.add(generic);
        } else {
            System.out.println("[warn] run in else");
        }
        return classGeneric;
    }

    private static Class<?> getClass(Type type, int i) {
        if (type instanceof ParameterizedType) {
            return GenericUtil.getGenericClass((ParameterizedType)type, i);
        }
        if (type instanceof TypeVariable) {
            return GenericUtil.getClass(((TypeVariable)type).getBounds()[0], 0);
        }
        return (Class)type;
    }

    private static Class<?> getGenericClass(ParameterizedType parameterizedType, int i) {
        Type genericClass = parameterizedType.getActualTypeArguments()[i];
        if (genericClass instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genericClass).getRawType();
        }
        if (genericClass instanceof GenericArrayType) {
            return (Class)((GenericArrayType)genericClass).getGenericComponentType();
        }
        if (genericClass instanceof TypeVariable) {
            return GenericUtil.getClass(((TypeVariable)genericClass).getBounds()[0], 0);
        }
        return (Class)genericClass;
    }

    public static class Generic {
        private String type;
        private ClassGeneric embedClassGeneric;

        public String getType() {
            return this.type;
        }

        public Generic setType(String type) {
            this.type = type;
            return this;
        }

        public ClassGeneric getEmbedClassGeneric() {
            return this.embedClassGeneric;
        }

        public Generic setEmbedClassGeneric(ClassGeneric embedClassGeneric) {
            this.embedClassGeneric = embedClassGeneric;
            return this;
        }

        public String toString() {
            return "Generic{type='" + this.type + '\'' + ", embedClassGeneric=" + this.embedClassGeneric + '}';
        }
    }

    private static class ClassGeneric {
        private ClassGeneric parent;
        private List<Generic> genericList;

        private ClassGeneric() {
        }

        public ClassGeneric getParent() {
            return this.parent;
        }

        public ClassGeneric setParent(ClassGeneric parent) {
            this.parent = parent;
            return this;
        }

        public List<Generic> getGenericList() {
            return this.genericList;
        }

        public ClassGeneric setGenericList(List<Generic> genericList) {
            this.genericList = genericList;
            return this;
        }

        public String toString() {
            return "ClassGeneric{parent=" + this.parent + ", genericList=" + this.genericList + '}';
        }
    }
}

