/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.common;

import java.util.Arrays;

public class ArrayUtil {
    public static byte[] combine(byte[] ... bytesArrays) {
        if (bytesArrays == null) {
            return null;
        }
        if (bytesArrays.length == 0) {
            return new byte[0];
        }
        byte[] result = null;
        for (byte[] bs : bytesArrays) {
            if (result == null) {
                result = bs;
                continue;
            }
            if (bs == null || bs.length <= 0) continue;
            int startIndex = result.length;
            result = Arrays.copyOf(result, result.length + bs.length);
            System.arraycopy(bs, 0, result, startIndex, bs.length);
        }
        return result;
    }

    public static int binarySearch(byte[] source, byte[] target) {
        return ArrayUtil.binarySearch(source, 0, source.length, target, 0, target.length, 0);
    }

    private static int binarySearch(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public static byte[] add(byte[] arr, byte ... data) {
        if (data != null && data.length > 0) {
            byte[] arrNew = Arrays.copyOf(arr, arr.length + data.length);
            System.arraycopy(data, 0, arrNew, arr.length, data.length);
            arr = arrNew;
        }
        return arr;
    }
}

