/*
 * Decompiled with CFR 0.152.
 */
package cn.t.common.response;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class PageableVo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final PageableVo EMPTY = new PageableVo(1, 0, 0L, Collections.emptyList());
    private final int pageNum;
    private final int pageSize;
    private final long total;
    private final int pages;
    private final List<Object> list;

    public int getPageNum() {
        return this.pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getTotal() {
        return this.total;
    }

    public int getPages() {
        return this.pages;
    }

    public List<Object> getList() {
        return this.list;
    }

    public PageableVo(int pageNum, int pageSize, long total, List<Object> list) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.total = total;
        this.pages = pageSize == 0 ? 0 : (int)((total + (long)pageSize - 1L) / (long)pageSize);
        this.list = list;
    }

    public static PageableVo empty() {
        return EMPTY;
    }

    public static PageableVo empty(int pageNum, int pageSize) {
        return new PageableVo(pageNum, pageSize, 0L, Collections.emptyList());
    }

    public String toString() {
        return "PageableVo{pageNum=" + this.pageNum + ", pageSize=" + this.pageSize + ", total=" + this.total + ", list=" + this.list + '}';
    }
}

