/*
 * Decompiled with CFR 0.152.
 */
package cn.t.common.mybatis.keygenerator;

import cn.t.common.mybatis.keygenerator.GenerateIdException;
import cn.t.common.mybatis.keygenerator.RedisKeyGenerator;
import cn.t.common.mybatis.keygenerator.UnSupportedDatabase;
import cn.t.util.common.reflect.ClassUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.defaults.DefaultSqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class RedisIdGenInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(RedisIdGenInterceptor.class);
    private static final Pattern INSERT_SQL_TABLE_NAME_REG = Pattern.compile("into\\s+([1-9_a-z]+)");
    private final Properties properties = new Properties();
    private final RedisKeyGenerator redisKeyGenerator;

    public Object intercept(Invocation invocation) throws InvocationTargetException, IllegalAccessException, SQLException {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        Object arg = invocation.getArgs()[1];
        if (SqlCommandType.INSERT == mappedStatement.getSqlCommandType() && StatementType.PREPARED == mappedStatement.getStatementType() && mappedStatement.getKeyGenerator() instanceof NoKeyGenerator) {
            Connection connection = ((Executor)invocation.getTarget()).getTransaction().getConnection();
            if (!"MySQL".equals(connection.getMetaData().getDatabaseProductName())) {
                throw new UnSupportedDatabase(connection.getCatalog());
            }
            String database = connection.getCatalog().toUpperCase();
            String tableName = this.getTableName(mappedStatement.getBoundSql(arg).getSql()).toUpperCase();
            logger.debug("\u83b7\u53d6\u5230\u6570\u636e\u5e93\u540d: {}, \u8868\u540d: {}", (Object)database, (Object)tableName);
            if (arg instanceof DefaultSqlSession.StrictMap) {
                Collection paramCollection;
                DefaultSqlSession.StrictMap paramMap = (DefaultSqlSession.StrictMap)arg;
                Object param = paramMap.get((Object)"collection");
                if (param != null && param instanceof Collection && (paramCollection = (Collection)param).size() > 0) {
                    Iterator it = paramCollection.iterator();
                    long id = this.redisKeyGenerator.generateId(database, tableName);
                    while (true) {
                        Object obj = it.next();
                        boolean success = this.tryToSetId(obj, id);
                        if (it.hasNext()) {
                            if (!success) continue;
                            id = this.redisKeyGenerator.generateId(database, tableName);
                            continue;
                        }
                        break;
                    }
                }
            } else {
                this.tryToSetId(arg, this.redisKeyGenerator.generateId(database, tableName));
            }
        }
        return invocation.proceed();
    }

    private boolean tryToSetId(Object obj, long id) throws InvocationTargetException, IllegalAccessException {
        Method method = ClassUtil.findMethod(obj.getClass(), (String)"setId", (Class[])new Class[]{Long.class});
        if (method == null) {
            ClassUtil.findMethod(obj.getClass(), (String)"setId", (Class[])new Class[]{Long.TYPE});
        }
        if (method != null) {
            method.invoke(obj, id);
            return true;
        }
        return false;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    private String getTableName(String sql) {
        Matcher matcher = INSERT_SQL_TABLE_NAME_REG.matcher(sql);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new GenerateIdException("\u83b7\u53d6\u4e0d\u5230\u8868\u540d: " + sql);
    }

    public RedisIdGenInterceptor(RedisKeyGenerator redisKeyGenerator) {
        this.redisKeyGenerator = redisKeyGenerator;
    }
}

