/*
 * Decompiled with CFR 0.152.
 */
package cn.t.common.mybatis.keygenerator;

import java.sql.Statement;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.springframework.data.redis.core.ValueOperations;

public class RedisKeyGenerator
implements KeyGenerator {
    private static final String ID_KEY_PREFIX = "GENERATE_ID:";
    private final ValueOperations<String, String> valueOperations;
    private final long step = 2L;
    private long current = 0L;
    private long last = -1L;

    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
    }

    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
    }

    synchronized long generateId(String db, String table) {
        Long result;
        String key = ID_KEY_PREFIX.concat(db.concat(":").concat(table).toUpperCase());
        if (this.current > this.last && (result = this.valueOperations.increment((Object)key, 2L)) != null) {
            this.last = result;
            this.current = this.last - 2L + 1L;
        }
        return this.current++;
    }

    public RedisKeyGenerator(ValueOperations<String, String> valueOperations) {
        this.valueOperations = valueOperations;
    }
}

