/*
 * Decompiled with CFR 0.152.
 */
package cn.t.common.mybatis.keygenerator;

import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;

public class InMemoryKeyGenerator
implements KeyGenerator {
    private final AtomicInteger id = new AtomicInteger(1);

    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        this.processGeneratedKeys(ms, parameter);
    }

    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
    }

    private void processGeneratedKeys(MappedStatement ms, Object parameter) {
        try {
            String[] keyProperties = ms.getKeyProperties();
            Configuration configuration = ms.getConfiguration();
            MetaObject metaParam = configuration.newMetaObject(parameter);
            if (keyProperties != null) {
                MetaObject metaResult = configuration.newMetaObject((Object)this.id.getAndIncrement());
                this.setValue(metaParam, keyProperties[0], metaResult.getValue(keyProperties[0]));
            }
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutorException("Error selecting key or setting result to parameter object. Cause: " + e, (Throwable)e);
        }
    }

    private void setValue(MetaObject metaParam, String property, Object value) {
        if (!metaParam.hasSetter(property)) {
            throw new ExecutorException("No setter found for the keyProperty '" + property + "' in " + metaParam.getOriginalObject().getClass().getName() + ".");
        }
        metaParam.setValue(property, value);
    }
}

