/*
 * Decompiled with CFR 0.152.
 */
package cn.t.common.feign;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class CamelCaseClientConfig {
    private static final ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS}).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).serializationInclusion(JsonInclude.Include.NON_NULL)).build();
    private static final HttpMessageConverter<Object> jacksonConverter;
    private static final ObjectFactory<HttpMessageConverters> objectFactory;

    @Bean
    Decoder camelCaseFeignDecoder() {
        return new ResponseEntityDecoder((Decoder)new SpringDecoder(objectFactory));
    }

    @Bean
    Encoder camelCaseFeignEncoder() {
        return new SpringEncoder(objectFactory);
    }

    static {
        DateTimeFormatter deserializerDateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd[ [HH][:mm][:ss][.SSS]]").parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.MILLI_OF_SECOND, 0L).toFormatter();
        DateTimeFormatter serializerDateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").toFormatter();
        JavaTimeModule java8TimeModule = new JavaTimeModule();
        java8TimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(deserializerDateTimeFormatter));
        java8TimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(serializerDateTimeFormatter));
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        java8TimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(dateFormatter));
        java8TimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(dateFormatter));
        objectMapper.registerModule((Module)java8TimeModule);
        jacksonConverter = new MappingJackson2HttpMessageConverter(objectMapper);
        objectFactory = () -> new HttpMessageConverters(new HttpMessageConverter[]{jacksonConverter});
    }
}

