
package cn.sylinx.redis.springboot.lock;

public abstract class AbstractDistributedLockImpl implements DistributedLock {

	private int lockRetryCount = 1;

	public void setLockRetryCount(int lockRetryCount) {
		this.lockRetryCount = lockRetryCount;
	}

	@Override
	public <T> T exe(final String key, final IAction<T> action) {
		ILockable<T> lockable = new ILockable<T>() {
			@Override
			public String getKey() {
				return key;
			}

			@Override
			public T execute() {
				return action == null ? null : action.atomicAction();
			}
		};
		return exe(lockable);
	}

	@Override
	public <T extends Object> T exe(ILockable<T> lockable) {

		String key = lockable.getKey();
		boolean bl = lock(key);
		int count = 0;

		while (!bl && count < lockRetryCount) {
			bl = lock(key);
			count = count + 1;
		}

		if (!bl) {
			throw new RuntimeException("该操作无法完成，已被锁定，请稍后操作。");
		}

		try {
			return lockable.execute();

		} finally {
			unlock(key);
		}
	}

	/**
	 * 加锁 应该以： lock(key); try { doSomething(); } finally { unlock(key)； } 的方式调用
	 * 
	 * @return 成功或失败标志
	 */
	public abstract boolean lock(String key);

	/**
	 * 解锁 无论是否加锁成功，都需要调用unlock 应该以： lock(key); try { doSomething(); } finally {
	 * unlock(key)； } 的方式调用
	 */
	public abstract void unlock(String key);

}
