package cn.sylinx.redis.springboot;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.RedisConnectionFactory;

import cn.sylinx.redis.springboot.lock.DistributedLock;
import cn.sylinx.redis.springboot.lock.RedisDistributedLockImpl;

@Configuration
public class RedisStarter {

	@Bean
	public RedisCommand redisCommand(Environment environment, RedisConnectionFactory redisConnectionFactory) {

		RedisCommand rc = new RedisCommand();
		rc.setRedisConnectionFactory(redisConnectionFactory);
		// 检测redis健康状况,默认不检测
		boolean bl = environment.getProperty("spring.redis.detect", boolean.class, false);
		if (bl) {
			rc.detect();
		}
		return rc;
	}

	@Bean
	public DistributedLock distributedLock(Environment environment, RedisCommand redisCommand) {

		RedisDistributedLockImpl rdl = new RedisDistributedLockImpl();
		rdl.setRedisCommand(redisCommand);
		// 锁持续时间，默认3分钟
		rdl.setExpire(environment.getProperty("spring.redis.lock.expire", long.class, 180l));
		// 获取锁重试次数，默认1
		rdl.setLockRetryCount(environment.getProperty("spring.redis.lock.retrycount", int.class, 1));
		return rdl;
	}

}
