package cn.sylinx.redis.springboot;

import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.serializer.RedisSerializer;

import cn.sylinx.redis.springboot.serial.SerializerUtil;

public abstract class AbstractMessageListener implements MessageListener {

	@Override
	public void onMessage(Message message, byte[] pattern) {
		RedisSerializer<String> s = SerializerUtil.getStringRedisSerializer();
		String strPattern = s.deserialize(pattern);
		onMessage(message, strPattern);
	}

	public abstract void onMessage(Message message, String pattern);

}
