/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.redis.springboot.lock;

import cn.sylinx.redis.springboot.RedisCommand;
import cn.sylinx.redis.springboot.lock.AbstractDistributedLockImpl;
import java.util.Random;

public class RedisDistributedLockImpl
extends AbstractDistributedLockImpl {
    private RedisCommand redisCommand;
    private static final String LOCKED = "TRUE";
    private static final long MILLI_NANO_CONVERSION = 1000000L;
    private static final long DEFAULT_TIME_OUT = 500L;
    private static final Random RANDOM = new Random();
    private static final long EXPIRE = 180L;

    public void setRedisCommand(RedisCommand redisCommand) {
        this.redisCommand = redisCommand;
    }

    @Override
    public boolean lock(String key) {
        return this.lock(key, 500L, 180L);
    }

    @Override
    public void unlock(String key) {
        this.redisCommand.del(key);
    }

    private boolean lock(String key, long timeout, long secondsToRelease) {
        long nano = System.nanoTime();
        long timeoutInner = timeout * 1000000L;
        try {
            while (System.nanoTime() - nano < timeoutInner) {
                if (this.redisCommand.setnx(key, LOCKED).booleanValue()) {
                    this.redisCommand.expire(key, secondsToRelease);
                    return true;
                }
                Thread.sleep(3L, RANDOM.nextInt(500));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Locking error", e);
        }
        return false;
    }
}

