/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.redis.springboot;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RedisCommand {
    private StringRedisSerializer serializer = new StringRedisSerializer();
    private RedisConnectionFactory redisConnectionFactory;

    public void setRedisConnectionFactory(RedisConnectionFactory redisConnectionFactory) {
        this.redisConnectionFactory = redisConnectionFactory;
    }

    public Long publish(byte[] channel, byte[] message) {
        return this.executeCommand((c, o) -> c.publish(channel, message), new Object[0]);
    }

    public Long publish(String channel, String message) {
        return this.publish(this.serializer.serialize(channel), this.serializer.serialize(message));
    }

    public byte[] get(byte[] key) {
        return this.executeCommand((c, o) -> c.get(key), new Object[0]);
    }

    public String get(String key) {
        byte[] b = this.get(this.serializer.serialize(key));
        return this.serializer.deserialize(b);
    }

    public void set(byte[] key, byte[] value) {
        this.executeCommand((c, o) -> {
            c.set(key, value);
            return null;
        }, new Object[0]);
    }

    public void set(String key, String value) {
        this.set(this.serializer.serialize(key), this.serializer.serialize(value));
    }

    public Boolean setnx(byte[] key, byte[] value) {
        return this.executeCommand((c, o) -> c.setNX(key, value), new Object[0]);
    }

    public Boolean setnx(String key, String value) {
        return this.setnx(this.serializer.serialize(key), this.serializer.serialize(value));
    }

    public void hmset(byte[] key, Map<byte[], byte[]> hash) {
        this.executeCommand((c, o) -> {
            c.hMSet(key, hash);
            return null;
        }, new Object[0]);
    }

    public void hmset(String key, Map<String, String> hash) {
        byte[] bkey = this.serializer.serialize(key);
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>();
        if (hash != null) {
            for (Map.Entry<String, String> entry : hash.entrySet()) {
                bhash.put(this.serializer.serialize(entry.getKey()), this.serializer.serialize(entry.getValue()));
            }
        }
        this.hmset(bkey, bhash);
    }

    public void del(String ... keys) {
        if (keys == null || keys.length < 1) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
        }
        byte[][] btkeys = new byte[keys.length][];
        for (int i = 0; i < keys.length; ++i) {
            btkeys[i] = this.serializer.serialize(keys[i]);
        }
        this.del(btkeys);
    }

    public void del(byte[] ... keys) {
        this.executeCommand((c, o) -> {
            c.del(keys);
            return null;
        }, new Object[0]);
    }

    public Boolean expire(String key, long seconds) {
        return this.expire(this.serializer.serialize(key), seconds);
    }

    public Boolean expire(byte[] key, long seconds) {
        return this.executeCommand((c, o) -> c.expire(key, seconds), new Object[0]);
    }

    public Set<byte[]> keys(byte[] pattern) {
        return this.executeCommand((c, o) -> c.keys(pattern), new Object[0]);
    }

    public Set<String> keys(String pattern) {
        Set<byte[]> keys = this.keys(this.serializer.serialize(pattern));
        HashSet<String> strKeys = new HashSet<String>();
        for (byte[] key : keys) {
            strKeys.add(this.serializer.deserialize(key));
        }
        return strKeys;
    }

    public void setex(byte[] key, long seconds, byte[] value) {
        this.executeCommand((c, o) -> {
            c.setEx(key, seconds, value);
            return null;
        }, new Object[0]);
    }

    public void setex(String key, long seconds, String value) {
        this.setex(this.serializer.serialize(key), seconds, this.serializer.serialize(value));
    }

    public Boolean exists(byte[] key) {
        return this.executeCommand((c, o) -> c.exists(key), new Object[0]);
    }

    public Boolean exists(String key) {
        return this.exists(this.serializer.serialize(key));
    }

    public byte[] hget(byte[] key, byte[] field) {
        return this.executeCommand((c, o) -> c.hGet(key, field), new Object[0]);
    }

    public String hget(String key, String field) {
        byte[] rst = this.hget(this.serializer.serialize(key), this.serializer.serialize(field));
        return this.serializer.deserialize(rst);
    }

    public Map<byte[], byte[]> hgetAll(byte[] key) {
        return this.executeCommand((c, o) -> c.hGetAll(key), new Object[0]);
    }

    public Map<String, String> hgetAll(String key) {
        Map<byte[], byte[]> bmap = this.hgetAll(this.serializer.serialize(key));
        HashMap<String, String> smap = new HashMap<String, String>();
        if (bmap != null) {
            for (Map.Entry<byte[], byte[]> entry : bmap.entrySet()) {
                smap.put(this.serializer.deserialize(entry.getKey()), this.serializer.deserialize(entry.getValue()));
            }
        }
        return smap;
    }

    public Boolean hset(byte[] key, byte[] field, byte[] value) {
        return this.executeCommand((c, o) -> c.hSet(key, field, value), new Object[0]);
    }

    public Boolean hset(String key, String field, String value) {
        return this.hset(this.serializer.serialize(key), this.serializer.serialize(field), this.serializer.serialize(value));
    }

    public void subscribe(MessageListener listener, byte[] ... channels) {
        this.executeCommand((c, o) -> {
            c.subscribe(listener, channels);
            return null;
        }, new Object[0]);
    }

    public void subscribe(MessageListener listener, String ... channels) {
        byte[][] bchannels = new byte[channels.length][];
        for (int i = 0; i < channels.length; ++i) {
            bchannels[i] = this.serializer.serialize(channels[i]);
        }
        this.subscribe(listener, bchannels);
    }

    public void unsubscribe(byte[] ... channels) {
        this.executeCommand((c, o) -> {
            Subscription sub = c.getSubscription();
            if (sub != null) {
                sub.unsubscribe(channels);
            }
            return null;
        }, new Object[0]);
    }

    public void unsubscribe(String ... channels) {
        byte[][] bchannels = new byte[channels.length][];
        for (int i = 0; i < channels.length; ++i) {
            bchannels[i] = this.serializer.serialize(channels[i]);
        }
        this.unsubscribe(bchannels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeCommand(Executeable<T> exe, Object ... objects) {
        try (RedisConnection connection = this.redisConnectionFactory.getConnection();){
            T t = exe.cmd(connection, objects);
            return t;
        }
    }

    public static interface Executeable<T> {
        public T cmd(RedisConnection var1, Object ... var2);
    }
}

