package cn.sylinx.hbatis.ext.xmapper.repository;

import java.util.List;
import java.util.Map;

import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.ext.common.repository.CommonDaoService;
import cn.sylinx.hbatis.ext.xmapper.XmapperCacheQuery;

public interface DaoService extends CommonDaoService {

	/**
	 * 获取缓存查询对象
	 * @return
	 */
	public XmapperCacheQuery withCache();
	
	/**
	 * 查询Map列表
	 * 
	 * @param sqlId
	 * @param params
	 * @return
	 */
	public List<Map<String, Object>> queryForMapList(String sqlId, Map<String, Object> params);

	/**
	 * 查询Map列表
	 * 
	 * @param namespaceId
	 * @param id
	 * @param params
	 * @return
	 */
	public List<Map<String, Object>> queryForMapList(String namespaceId, String id, Map<String, Object> params);

	/**
	 * 查询
	 * 
	 * @param namespaceId
	 * @param id
	 * @param params
	 * @return
	 */
	public List<Record> queryForRecords(String namespaceId, String id, Map<String, Object> params);

	/**
	 * 查询记录
	 * 
	 * @param sqlId
	 * @param params
	 * @return
	 */
	public List<Record> queryForRecords(String sqlId, Map<String, Object> params);

	/**
	 * 查询第一条记录
	 * 
	 * @param namespaceId
	 * @param id
	 * @param params
	 * @return
	 */
	public Record queryFirstRecord(String namespaceId, String id, Map<String, Object> params);

	/**
	 * 查询第一条记录
	 * 
	 * @param sqlId
	 * @param params
	 * @return
	 */
	public Record queryFirstRecord(String sqlId, Map<String, Object> params);

	public List<Object[]> queryObjectArrayList(String namespaceId, String id, Map<String, Object> params);

	public List<Object[]> queryObjectArrayList(String sqlId, Map<String, Object> params);

	public Object[] queryFirstObjectArray(String namespaceId, String id, Map<String, Object> params);

	public Object[] queryFirstObjectArray(String sqlId, Map<String, Object> params);

	/**
	 * 查询第一个map
	 * 
	 * @param sqlId
	 * @param params
	 * @return
	 */
	public Map<String, Object> queryFirstForMap(String sqlId, Map<String, Object> params);

	/**
	 * 查询第一个map
	 * 
	 * @param namespaceId
	 * @param id
	 * @param params
	 * @return
	 */
	public Map<String, Object> queryFirstForMap(String namespaceId, String id, Map<String, Object> params);

	/**
	 * 通过配置文件获取对应对象列表
	 * 
	 * @param sqlId
	 * @return
	 */
	public <T> List<T> query(String sqlId, Map<String, Object> params);

	/**
	 * 通过配置文件获取对应对象列表
	 * 
	 * @param namespaceId
	 * @param id
	 * @return
	 */
	public <T> List<T> query(String namespaceId, String id, Map<String, Object> params);

	/**
	 * 通过配置文件获取对应对象列表
	 * 
	 * @param sqlId
	 * @return
	 */
	public <T> T queryFirst(String sqlId, Map<String, Object> params);

	/**
	 * 通过配置文件获取对应对象列表
	 * 
	 * @param namespaceId
	 * @param id
	 * @return
	 */
	public <T> T queryFirst(String namespaceId, String id, Map<String, Object> params);

	/**
	 * update
	 * 
	 * @param sqlId
	 * @param params
	 * @return
	 */
	public int update(String sqlId, Map<String, Object> params);

	/**
	 * update
	 * 
	 * @param namespaceId
	 * @param id
	 * @param params
	 * @return
	 */
	public int update(String namespaceId, String id, Map<String, Object> params);

	/**
	 * delete
	 * 
	 * @param sqlId
	 * @param params
	 * @return
	 */
	public int delete(String sqlId, Map<String, Object> params);

	/**
	 * delete
	 * 
	 * @param namespaceId
	 * @param id
	 * @param params
	 * @return
	 */
	public int delete(String namespaceId, String id, Map<String, Object> params);

	/**
	 * save
	 * 
	 * @param sqlId
	 * @param params
	 * @return
	 */
	public Object save(String sqlId, Map<String, Object> params);

	/**
	 * save
	 * 
	 * @param namespaceId
	 * @param id
	 * @param params
	 * @return
	 */
	public Object save(String namespaceId, String id, Map<String, Object> params);
}
