package cn.sylinx.hbatis.ext.xmapper;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

import cn.sylinx.hbatis.db.common.DbOper;
import cn.sylinx.hbatis.db.common.DefaultHbatisService;
import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import cn.sylinx.hbatis.ext.parse.SqlParser;
import cn.sylinx.hbatis.ext.res.StatementHandler;
import cn.sylinx.hbatis.ext.xmapper.xml.QueryMapping;
import cn.sylinx.hbatis.ext.xmapper.xml.Sql;
import cn.sylinx.hbatis.ext.xmapper.xml.SqlForUse;
import cn.sylinx.hbatis.ext.xmapper.xml.XmlSqlMapper;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.kit.Tuple;
import cn.sylinx.hbatis.plugin.JdbcResourcePlugin;

public class DefaultXmapperService extends DefaultHbatisService implements XmapperService {

	private String datasourceName;

	private final XmapperCacheQuery xmapperCacheQuery;

	private final Map<String, XmapperService> dbServiceMap = new WeakHashMap<String, XmapperService>();

	public DefaultXmapperService() {
		this(JdbcResourcePlugin.DEFAULT_JDBC_RESOURCE_NAME);
	}

	public DefaultXmapperService(String datasourceName) {
		super(datasourceName);
		this.datasourceName = datasourceName;
		this.xmapperCacheQuery = createXmapperCacheQuery();
		dbServiceMap.put(datasourceName, this);
	}

	/**
	 * 创建缓存查询对象
	 * 
	 * @param params
	 * @return
	 */
	private XmapperCacheQuery createXmapperCacheQuery(Object... params) {
		return new DefaultXmapperCacheQuery(getCacheQuery());
	}

	@Override
	public XmapperCacheQuery withXmapperCache() {
		if (getCacheQuery() == null || xmapperCacheQuery == null) {
			throw new UnsupportedOperationException("不支持缓存查询");
		}
		return xmapperCacheQuery;
	}

	@Override
	public XmapperService useService(String datasourceName) {

		XmapperService dbService = dbServiceMap.get(datasourceName);
		if (dbService == null) {

			synchronized (datasourceName.intern()) {
				createInstanceInner(datasourceName);
			}

			dbService = dbServiceMap.get(datasourceName);
		}

		return dbService;

	}

	private void createInstanceInner(String datasourceName) {

		XmapperService dbService = dbServiceMap.get(datasourceName);
		if (dbService == null) {
			dbService = createInstance(datasourceName);
			dbServiceMap.put(datasourceName, dbService);
		}
	}

	protected XmapperService createInstance(String datasourceName) {
		return new DefaultXmapperService(datasourceName);
	}

	@Override
	public DbOper getDbOper() {
		return this;
	}

	@Override
	public <T> List<T> query(String sqlId, Map<String, Object> params) {

		String[] ids = sqlId.split("\\.");
		String namespaceId = ids[0];
		String id = ids[1];
		return query(namespaceId, id, params);
	}

	@Override
	public Map<String, Object> queryFirstForMap(String namespaceId, String id, Map<String, Object> params) {

		if (!XmlSqlMapper.get().isInited()) {
			throw new RuntimeException("xmlSqlmapper plugin not started~");
		}

		Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);

		String forUse = sql.getForUse();
		if (!SqlForUse.QUERY.getCode().equals(forUse)) {
			throw new IllegalArgumentException("sql is not query for use");
		}

		Tuple tp = getQueryStatement(sql.getStatement(), params);
		String st = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);

		return useService(datasourceName).queryFirstMap(st, pms);
	}

	@Override
	public Map<String, Object> queryFirstForMap(String sqlId, Map<String, Object> params) {

		String[] ids = sqlId.split("\\.");
		String namespaceId = ids[0];
		String id = ids[1];

		return queryFirstForMap(namespaceId, id, params);
	}

	@Override
	public List<Map<String, Object>> queryForMapList(String sqlId, Map<String, Object> params) {

		String[] ids = sqlId.split("\\.");
		String namespaceId = ids[0];
		String id = ids[1];

		return queryForMapList(namespaceId, id, params);
	}

	@Override
	public List<Record> queryForRecords(String namespaceId, String id, Map<String, Object> params) {

		if (!XmlSqlMapper.get().isInited()) {
			throw new RuntimeException("xmlSqlmapper plugin not started~");
		}

		Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);

		String forUse = sql.getForUse();
		if (!SqlForUse.QUERY.getCode().equals(forUse)) {
			throw new IllegalArgumentException("sql is not query for use");
		}

		Tuple tp = getQueryStatement(sql.getStatement(), params);
		String st = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);

		return useService(datasourceName).queryRecords(st, pms);
	}

	@Override
	public List<Record> queryForRecords(String sqlId, Map<String, Object> params) {

		String[] ids = sqlId.split("\\.");
		String namespaceId = ids[0];
		String id = ids[1];

		return queryForRecords(namespaceId, id, params);
	}

	@Override
	public Record queryFirstRecord(String namespaceId, String id, Map<String, Object> params) {

		if (!XmlSqlMapper.get().isInited()) {
			throw new RuntimeException("xmlSqlmapper plugin not started~");
		}

		Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);

		String forUse = sql.getForUse();
		if (!SqlForUse.QUERY.getCode().equals(forUse)) {
			throw new IllegalArgumentException("sql is not query for use");
		}

		Tuple tp = getQueryStatement(sql.getStatement(), params);
		String st = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);

		return useService(datasourceName).queryFirstRecord(st, pms);
	}

	@Override
	public Record queryFirstRecord(String sqlId, Map<String, Object> params) {

		String[] ids = sqlId.split("\\.");
		String namespaceId = ids[0];
		String id = ids[1];

		return queryFirstRecord(namespaceId, id, params);
	}

	@Override
	public List<Object[]> queryObjectArrayList(String namespaceId, String id, Map<String, Object> params) {

		if (!XmlSqlMapper.get().isInited()) {
			throw new RuntimeException("xmlSqlmapper plugin not started~");
		}

		Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);

		String forUse = sql.getForUse();
		if (!SqlForUse.QUERY.getCode().equals(forUse)) {
			throw new IllegalArgumentException("sql is not query for use");
		}

		Tuple tp = getQueryStatement(sql.getStatement(), params);
		String st = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);

		return useService(datasourceName).query(st, pms);
	}

	@Override
	public List<Object[]> queryObjectArrayList(String sqlId, Map<String, Object> params) {

		String[] ids = sqlId.split("\\.");
		String namespaceId = ids[0];
		String id = ids[1];

		return queryObjectArrayList(namespaceId, id, params);
	}

	/**
	 * 带有StatementHandler
	 * 
	 * @param statement
	 * @param params
	 * @return
	 */
	private Tuple getQueryStatement(String statement, Map<String, Object> params) {

		StatementHandler sqlHandler = null;
		if (params != null) {
			Object obj = params.get(StatementHandler.class.getName());
			if (obj != null && (obj instanceof StatementHandler)) {
				sqlHandler = (StatementHandler) obj;
			}
		}
		return SqlParser.parseSql(statement, params, sqlHandler);
	}

	@Override
	public Object[] queryFirstObjectArray(String namespaceId, String id, Map<String, Object> params) {

		if (!XmlSqlMapper.get().isInited()) {
			throw new RuntimeException("xmlSqlmapper plugin not started~");
		}

		Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);

		String forUse = sql.getForUse();
		if (!SqlForUse.QUERY.getCode().equals(forUse)) {
			throw new IllegalArgumentException("sql is not query for use");
		}

		Tuple tp = getQueryStatement(sql.getStatement(), params);
		String st = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);

		return useService(datasourceName).queryFirst(st, pms);
	}

	@Override
	public Object[] queryFirstObjectArray(String sqlId, Map<String, Object> params) {

		String[] ids = sqlId.split("\\.");
		String namespaceId = ids[0];
		String id = ids[1];

		return queryFirstObjectArray(namespaceId, id, params);
	}

	@Override
	public List<Map<String, Object>> queryForMapList(String namespaceId, String id, Map<String, Object> params) {

		if (!XmlSqlMapper.get().isInited()) {
			throw new RuntimeException("xmlSqlmapper plugin not started~");
		}

		Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);

		String forUse = sql.getForUse();
		if (!SqlForUse.QUERY.getCode().equals(forUse)) {
			throw new IllegalArgumentException("sql is not query for use");
		}

		Tuple tp = getQueryStatement(sql.getStatement(), params);
		String st = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);

		return useService(datasourceName).queryMap(st, pms);
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> List<T> query(String namespaceId, String id, Map<String, Object> params) {

		if (!XmlSqlMapper.get().isInited()) {
			throw new RuntimeException("xmlSqlmapper plugin not started~");
		}

		Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);

		String forUse = sql.getForUse();
		if (!SqlForUse.QUERY.getCode().equals(forUse)) {
			throw new IllegalArgumentException("sql is not query for use");
		}

		Tuple tp = getQueryStatement(sql.getStatement(), params);
		String st = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);

		final QueryMapping qm = sql.getQueryMapping();
		QueryMapper<T> qmapper = null;

		if (qm != null) {
			qmapper = new QueryMapper<T>() {

				@Override
				public Map<String, String> getJdbcToJavaMapper() {
					return qm.getMap();
				}

				@Override
				public Class<T> getValueObjectClass() {

					try {
						String clzStr = qm.getReturnClass();
						if (StrKit.notBlank(clzStr)) {
							return (Class<T>) Class.forName(clzStr);
						}
						return null;
					} catch (Exception e) {
						return null;
					}

				}
			};
		}

		return useService(datasourceName).query(st, qmapper, pms);
	}

	@Override
	public <T> T queryFirst(String sqlId, Map<String, Object> params) {

		List<T> list = query(sqlId, params);

		return list != null && !list.isEmpty() ? list.get(0) : null;
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T queryFirst(String namespaceId, String id, Map<String, Object> params) {

		if (!XmlSqlMapper.get().isInited()) {
			throw new RuntimeException("xmlSqlmapper plugin not started~");
		}

		Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);

		String forUse = sql.getForUse();
		if (!SqlForUse.QUERY.getCode().equals(forUse)) {
			throw new IllegalArgumentException("sql is not query for use");
		}

		final QueryMapping qm = sql.getQueryMapping();
		Tuple tp = getQueryStatement(sql.getStatement(), params);
		String st = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);

		QueryMapper<T> qmapper = null;

		if (qm != null) {
			qmapper = new QueryMapper<T>() {

				@Override
				public Map<String, String> getJdbcToJavaMapper() {
					return qm.getMap();
				}

				@Override
				public Class<T> getValueObjectClass() {

					try {
						String clzStr = qm.getReturnClass();
						if (StrKit.notBlank(clzStr)) {
							return (Class<T>) Class.forName(clzStr);
						}
						return null;
					} catch (Exception e) {
						return null;
					}

				}
			};
		}

		return useService(datasourceName).queryFirst(st, qmapper, pms);
	}

	@Override
	public int update(String sqlId, Map<String, Object> params) {

		String[] ids = sqlId.split("\\.");
		String namespaceId = ids[0];
		String id = ids[1];

		return update(namespaceId, id, params);
	}

	@Override
	public int update(String namespaceId, String id, Map<String, Object> params) {

		if (!XmlSqlMapper.get().isInited()) {
			throw new RuntimeException("xmlSqlmapper plugin not started~");
		}

		Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);

		String forUse = sql.getForUse();
		if (!SqlForUse.UPDATE.getCode().equals(forUse)) {
			throw new IllegalArgumentException("sql is not update for use");
		}

		Tuple tp = getQueryStatement(sql.getStatement(), params);
		String updateSql = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);

		return useService(datasourceName).update(updateSql, pms);
	}

	@Override
	public int delete(String sqlId, Map<String, Object> params) {

		String[] ids = sqlId.split("\\.");
		String namespaceId = ids[0];
		String id = ids[1];

		return delete(namespaceId, id, params);
	}

	@Override
	public int delete(String namespaceId, String id, Map<String, Object> params) {

		if (!XmlSqlMapper.get().isInited()) {
			throw new RuntimeException("xmlSqlmapper plugin not started~");
		}

		Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);

		String forUse = sql.getForUse();
		if (!SqlForUse.DELETE.getCode().equals(forUse)) {
			throw new IllegalArgumentException("sql is not delete for use");
		}

		Tuple tp = getQueryStatement(sql.getStatement(), params);
		String deleteSql = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);

		return useService(datasourceName).update(deleteSql, pms);
	}

	@Override
	public Object save(String sqlId, Map<String, Object> params) {

		String[] ids = sqlId.split("\\.");
		String namespaceId = ids[0];
		String id = ids[1];

		return save(namespaceId, id, params);
	}

	@Override
	public Object save(String namespaceId, String id, Map<String, Object> params) {

		if (!XmlSqlMapper.get().isInited()) {
			throw new RuntimeException("xmlSqlmapper plugin not started~");
		}

		Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);

		String forUse = sql.getForUse();
		if (!SqlForUse.INSERT.getCode().equals(forUse)) {
			throw new IllegalArgumentException("sql is not insert for use");
		}

		Tuple tp = getQueryStatement(sql.getStatement(), params);
		String insertSql = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);

		return useService(datasourceName).save(insertSql, pms);
	}

}
