/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.springboot.starter;

import cn.sylinx.hbatis.ext.xmapper.plugin.XmapperPlugin;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.IPlugin;
import cn.sylinx.hbatis.plugin.PluginStarter;
import cn.sylinx.hbatis.plugin.datasource.DataSourcePlugin;
import cn.sylinx.hbatis.plugin.ehcache.EhcachePlugin;
import cn.sylinx.hbatis.plugin.model.ModelPreloadPlugin;
import com.alibaba.druid.pool.DruidDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

@Configuration
public class HbatisStarter
implements EnvironmentAware,
DisposableBean {
    private DruidDataSource defaultDataSource;
    private Map<String, DruidDataSource> multiDataSources = new HashMap<String, DruidDataSource>();
    private List<IPlugin> pluginList = new ArrayList<IPlugin>();
    private PluginStarter pluginStarter;

    private DruidDataSource buildDataSource(Map<String, Object> dsMap) {
        DruidDataSource cds = new DruidDataSource();
        cds.setUrl(dsMap.get("url").toString());
        cds.setUsername(dsMap.get("username").toString());
        cds.setPassword(dsMap.get("password").toString());
        cds.setInitialSize(Integer.valueOf(dsMap.get("initalSize").toString()).intValue());
        cds.setMinIdle(Integer.valueOf(dsMap.get("minIdle").toString()).intValue());
        cds.setMaxActive(Integer.valueOf(dsMap.get("maxActive").toString()).intValue());
        cds.setDbType(dsMap.get("dbtype").toString());
        return cds;
    }

    public void setEnvironment(Environment env) {
        this.initDefaultDataSource(env);
        this.initMultiDataSources(env);
        this.initDataSourcePlugin(env);
        this.initXmapperPlugin(env);
        this.initModelPreLoadPlugin(env);
        this.initEhcachePlugin(env);
        this.initPluginStarter();
    }

    private void initPluginStarter() {
        this.pluginStarter = new PluginStarter(this.pluginList);
        this.pluginStarter.start();
    }

    private void initDataSourcePlugin(Environment env) {
        DataSourcePlugin p = new DataSourcePlugin();
        p.setDataSource((DataSource)this.defaultDataSource);
        p.setDbType(this.defaultDataSource.getDbType());
        this.pluginList.add((IPlugin)p);
        Set<Map.Entry<String, DruidDataSource>> kvSets = this.multiDataSources.entrySet();
        for (Map.Entry<String, DruidDataSource> kv : kvSets) {
            DataSourcePlugin ptmp = new DataSourcePlugin();
            ptmp.setDataSource((DataSource)kv.getValue());
            ptmp.setJdbcResourceName(kv.getKey());
            ptmp.setDbType(kv.getValue().getDbType());
            this.pluginList.add((IPlugin)ptmp);
        }
    }

    private void initXmapperPlugin(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.xmapper.");
        String inited = propertyResolver.getProperty("inited");
        if (!"true".equalsIgnoreCase(inited)) {
            return;
        }
        GLog.debug((String)"XmapperPlugin inited.", (Object[])new Object[0]);
        String resourcePath = propertyResolver.getProperty("resourcePath");
        if (resourcePath == null || "".equals(resourcePath)) {
            resourcePath = "xmapper";
        }
        GLog.debug((String)"XmapperPlugin resourcePath:{}", (Object[])new Object[]{resourcePath});
        XmapperPlugin xmapperPlugin = new XmapperPlugin(resourcePath);
        this.pluginList.add((IPlugin)xmapperPlugin);
    }

    private void initModelPreLoadPlugin(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.modelpreload.");
        String inited = propertyResolver.getProperty("inited");
        if (!"true".equalsIgnoreCase(inited)) {
            return;
        }
        GLog.debug((String)"ModelPreloadPlugin inited.", (Object[])new Object[0]);
        String scanPackageList = propertyResolver.getProperty("scanPackageList");
        if (scanPackageList == null || "".equals(scanPackageList)) {
            return;
        }
        GLog.debug((String)"ModelPreloadPlugin scanPackageList:{}", (Object[])new Object[]{scanPackageList});
        ModelPreloadPlugin mp = new ModelPreloadPlugin();
        String[] pkgArray = scanPackageList.split(",");
        mp.setScanPackageList(Arrays.asList(pkgArray));
        this.pluginList.add((IPlugin)mp);
    }

    private void initEhcachePlugin(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.ehcache.");
        String inited = propertyResolver.getProperty("inited");
        if (!"true".equalsIgnoreCase(inited)) {
            return;
        }
        GLog.debug((String)"EhcachePlugin inited.", (Object[])new Object[0]);
        this.pluginList.add((IPlugin)new EhcachePlugin());
    }

    private void initDefaultDataSource(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.datasource.default.");
        HashMap<String, Object> dsMap = new HashMap<String, Object>();
        dsMap.put("url", propertyResolver.getProperty("url"));
        dsMap.put("username", propertyResolver.getProperty("username"));
        dsMap.put("password", propertyResolver.getProperty("password"));
        dsMap.put("initalSize", propertyResolver.getProperty("initalSize", "2"));
        dsMap.put("minIdle", propertyResolver.getProperty("minIdle", "1"));
        dsMap.put("maxActive", propertyResolver.getProperty("maxActive", "20"));
        dsMap.put("dbtype", propertyResolver.getProperty("dbtype"));
        this.defaultDataSource = this.buildDataSource(dsMap);
    }

    private void initMultiDataSources(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.datasource.multi.");
        String dsPrefixs = propertyResolver.getProperty("names");
        if (dsPrefixs == null || "".equals(dsPrefixs)) {
            return;
        }
        for (String dsPrefix : dsPrefixs.split(",")) {
            Map dsMap = propertyResolver.getSubProperties(dsPrefix + ".");
            DruidDataSource ds = this.buildDataSource(dsMap);
            this.multiDataSources.put(dsPrefix, ds);
        }
    }

    public void destroy() throws Exception {
        if (this.pluginStarter != null) {
            this.pluginStarter.stop();
        }
    }
}

