package cn.sylinx.hbatis.springboot.starter;

import java.util.HashMap;
import java.util.Map;

import cn.sylinx.hbatis.db.dialect.DbType;

public enum ValidateQuery {

	ME;

	private Map<DbType, String> validateQueryMaps;

	private ValidateQuery() {
		
		if (validateQueryMaps == null) {
			validateQueryMaps = new HashMap<DbType, String>();
		}

		validateQueryMaps.put(DbType.DB2, "select 1 from sysibm.sysdummy1");
		validateQueryMaps.put(DbType.DERBY, "values 1");
		validateQueryMaps.put(DbType.MYSQL, "select 1");
		validateQueryMaps.put(DbType.ORACLE, "select 1 from dual");
		validateQueryMaps.put(DbType.SQLSERVER, "select 1");
	}

	public String getValidateQuery(String dbtype) {
		DbType dt = DbType.getDbType(dbtype);
		return validateQueryMaps.get(dt);
	}

}
