package cn.sylinx.hbatis.ext.mirage.repository;

import java.util.List;
import java.util.Map;

import cn.sylinx.hbatis.db.common.Page;
import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.ext.common.repository.CommonDaoService;
import cn.sylinx.hbatis.ext.res.ClasspathSqlResource;

/**
 * DAO服务
 * 
 * @author hanqz
 *
 */
public interface DaoService extends CommonDaoService {

	/**
	 * 更新操作
	 * 
	 * 
	 * @param sqlResource
	 * @return
	 */
	int update(String sqlResource);
	
	/**
	 * 更新并获取主键
	 * 
	 * 
	 * @param sqlResource
	 * @param params
	 * @return
	 */
	Object updateWithReturnPk(String sqlResource, Map<String, Object> params);

	/**
	 * 更新并获取主键
	 * 
	 * @param resource
	 * @param params
	 * @return
	 */
	Object updateWithReturnPk(ClasspathSqlResource resource, Map<String, Object> params);

	/**
	 * 执行脚本，包括ddl
	 * 
	 * 
	 * @param sqlResource
	 */
	boolean execute(String sqlResource);

	boolean execute(String sqlResource, Map<String, Object> params);

	boolean execute(ClasspathSqlResource resource, Map<String, Object> params);

	

	/**
	 * 更新操作
	 * 
	 * 
	 * @param sqlResource
	 * @param params
	 * @return
	 */
	int update(String sqlResource, Map<String, Object> params);

	int update(ClasspathSqlResource resource, Map<String, Object> params);

	

	/**
	 * 删除
	 * 
	 * 
	 * @param sqlResource
	 * @param params
	 * @return
	 */
	int delete(String sqlResource, Map<String, Object> params);

	int delete(ClasspathSqlResource resource, Map<String, Object> params);

	/**
	 * 删除
	 * 
	 * 
	 * @param sqlResource
	 * @return
	 */
	int delete(String sqlResource);

	<T> List<T> queryList(String sqlResource, Map<String, Object> params, Class<T> clz);

	<T> List<T> queryList(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz);

	<T> T queryFirst(String sqlResource, Map<String, Object> params, Class<T> clz);

	<T> T queryFirst(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz);

	<T> List<T> queryList(String sqlResource, Class<T> clz);

	<T> T queryFirst(String sqlResource, Class<T> clz);

	/**
	 * 查询单个对象
	 * 
	 * 
	 * @param resource
	 * @param params
	 * @return
	 */
	Record queryRecord(String sqlResource, Map<String, Object> params);

	Record queryRecord(ClasspathSqlResource resource, Map<String, Object> params);

	/**
	 * 查询单个对象
	 * 
	 * 
	 * @param resource
	 * @return
	 */
	Record queryRecord(String sqlResource);

	/**
	 * 查询对象列表
	 * 
	 * 
	 * @param resource
	 * @param params
	 * @return
	 */
	List<Record> queryRecords(String sqlResource, Map<String, Object> params);

	List<Record> queryRecords(ClasspathSqlResource resource, Map<String, Object> params);

	/**
	 * 查询对象列表
	 * 
	 * 
	 * @param resource
	 * @return
	 */
	List<Record> queryRecords(String sqlResource);

	/**
	 * 分页查询
	 * 
	 * 
	 * @param sqlResource
	 *            查询语句
	 * @param pageNumber
	 *            当前页
	 * @param pageSize
	 *            每页数量
	 * @param params
	 *            查询参数
	 * @return
	 */
	<T> Page<T> queryPage(String sqlResource, int pageNumber, int pageSize, Map<String, Object> params, Class<T> clz);

	<T> Page<T> queryPage(String sqlResource, int pageNumber, Map<String, Object> params, Class<T> clz);

	<T> Page<T> queryPage(String sqlResource, int pageNumber, Class<T> clz);

	<T> Page<T> queryPage(String sqlResource, int pageNumber, int pageSize, Class<T> clz);

	/**
	 * 分页查询
	 * 
	 * 
	 * @param pageNumber
	 * @param pageSize
	 * @param params
	 * @return
	 */
	Page<Record> queryPageRecords(String sqlResource, int pageNumber, int pageSize, Map<String, Object> params);

	Page<Record> queryPageRecords(String sqlResource, int pageNumber, Map<String, Object> params);

	Page<Record> queryPageRecords(String sqlResource, int pageNumber);

	Page<Record> queryPageRecords(String sqlResource, int pageNumber, int pageSize);

	<T> List<T> queryListWithCache(String sqlResource, Map<String, Object> params, Class<T> clz);

	<T> List<T> queryListWithCache(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz);

	<T> T queryFirstWithCache(String sqlResource, Map<String, Object> params, Class<T> clz);

	<T> T queryFirstWithCache(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz);

	<T> List<T> queryListWithCache(String sqlResource, Class<T> clz);

	<T> T queryFirstWithCache(String sqlResource, Class<T> clz);

	/**
	 * 查询单个对象
	 * 
	 * 
	 * @param resource
	 * @param params
	 * @return
	 */
	Record queryRecordWithCache(String sqlResource, Map<String, Object> params);

	Record queryRecordWithCache(ClasspathSqlResource resource, Map<String, Object> params);

	/**
	 * 查询单个对象
	 * 
	 * 
	 * @param resource
	 * @return
	 */
	Record queryRecordWithCache(String sqlResource);

	/**
	 * 查询对象列表
	 * 
	 * 
	 * @param resource
	 * @param params
	 * @return
	 */
	List<Record> queryRecordsWithCache(String sqlResource, Map<String, Object> params);

	List<Record> queryRecordsWithCache(ClasspathSqlResource resource, Map<String, Object> params);

	/**
	 * 查询对象列表
	 * 
	 * 
	 * @param sqlResource
	 * @return
	 */
	List<Record> queryRecordsWithCache(String sqlResource);

}
