/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.mirage.spi;

import cn.sylinx.hbatis.ext.mirage.MirageService;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantLock;

public class MirageServiceManager {
    private static MirageService mirageService;
    private static ReentrantLock lock;

    public static MirageService getMirageService() {
        if (mirageService != null) {
            return mirageService;
        }
        MirageServiceManager.loadMirageService();
        return mirageService;
    }

    private static void loadMirageService() {
        try {
            lock.lock();
            if (mirageService == null) {
                ServiceLoader<MirageService> sl = ServiceLoader.load(MirageService.class);
                Iterator<MirageService> it = sl.iterator();
                mirageService = it.hasNext() ? it.next() : null;
            }
        }
        finally {
            lock.unlock();
        }
    }

    static {
        lock = new ReentrantLock();
    }
}

