package cn.sylinx.hbatis.ext.mirage;

import java.util.List;
import java.util.Map;

import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.ext.res.ClasspathSqlResource;

public interface MirageCacheQuery {

	/**
	 * 查询Map列表
	 * 
	 * @param sqlId
	 * @param params
	 * @return
	 */
	public List<Map<String, Object>> queryForMapList(ClasspathSqlResource sqlResource, Map<String, Object> params);

	/**
	 * 查询记录
	 * 
	 * @param sqlId
	 * @param params
	 * @return
	 */
	public List<Record> queryForRecords(ClasspathSqlResource sqlResource, Map<String, Object> params);

	/**
	 * 查询第一条记录
	 * 
	 * @param sqlId
	 * @param params
	 * @return
	 */
	public Record queryFirstRecord(ClasspathSqlResource sqlResource, Map<String, Object> params);

	/**
	 * 查询记录
	 * 
	 * @param sqlResource
	 * @param params
	 * @return
	 */
	public List<Object[]> queryObjectArrayList(ClasspathSqlResource sqlResource, Map<String, Object> params);

	/**
	 * 查询第一条记录
	 * 
	 * @param sqlResource
	 * @param params
	 * @return
	 */
	public Object[] queryFirstObjectArray(ClasspathSqlResource sqlResource, Map<String, Object> params);

	/**
	 * 查询第一个map
	 * 
	 * @param sqlId
	 * @param params
	 * @return
	 */
	public Map<String, Object> queryFirstForMap(ClasspathSqlResource sqlResource, Map<String, Object> params);

	/**
	 * 通过配置文件获取对应对象列表
	 * 
	 * @param sqlId
	 * @return
	 */
	public <T> List<T> query(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> clz);

	/**
	 * 通过配置文件获取对应对象列表
	 * 
	 * @param sqlId
	 * @return
	 */
	public <T> T queryFirst(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> clz);

}
