package cn.sylinx.hbatis.ext.mirage.repository;

import java.util.List;
import java.util.Map;

import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.ext.common.repository.CommonRepositoryImpl;
import cn.sylinx.hbatis.ext.mirage.spi.MirageServiceManager;
import cn.sylinx.hbatis.ext.parse.SqlParser;
import cn.sylinx.hbatis.ext.res.ClasspathSqlResource;
import cn.sylinx.hbatis.kit.Tuple;

public class RepositoryImpl extends CommonRepositoryImpl implements Repository {

	public RepositoryImpl() {

	}

	public RepositoryImpl(String datasourceName) {
		super(datasourceName);
	}

	@Override
	public int insert(ClasspathSqlResource resource, Map<String, Object> params) {
		return MirageServiceManager.getMirageService().useService(getDatabase()).update(resource, params);
	}

	@Override
	public int insert(ClasspathSqlResource resource) {
		return insert(resource, null);
	}

	@Override
	public Record queryRecord(ClasspathSqlResource resource, Map<String, Object> params) {
		return MirageServiceManager.getMirageService().useService(getDatabase()).queryFirstRecord(resource, params);
	}

	@Override
	public Record queryRecord(ClasspathSqlResource resource) {
		return queryRecord(resource, null);
	}

	@Override
	public List<Record> queryRecords(ClasspathSqlResource resource, Map<String, Object> params) {
		return MirageServiceManager.getMirageService().useService(getDatabase()).queryForRecords(resource, params);
	}

	@Override
	public List<Record> queryRecords(ClasspathSqlResource resource) {
		return queryRecords(resource, null);
	}

	@Override
	public int update(ClasspathSqlResource resource, Map<String, Object> params) {
		return MirageServiceManager.getMirageService().useService(getDatabase()).update(resource, params);
	}

	@Override
	public Object updateWithReturnPk(ClasspathSqlResource resource, Map<String, Object> params) {

		Tuple tp = SqlParser.parseSql(resource, params);
		String st = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);
		return MirageServiceManager.getMirageService().useService(getDatabase()).updateWithReturnPk(st, pms);
	}

	@Override
	public int update(ClasspathSqlResource resource) {
		return update(resource, null);
	}

	@Override
	public int delete(ClasspathSqlResource resource, Map<String, Object> params) {
		return MirageServiceManager.getMirageService().useService(getDatabase()).delete(resource, params);
	}

	@Override
	public int delete(ClasspathSqlResource resource) {
		return delete(resource, null);
	}

	@Override
	public Record queryRecordWithCache(ClasspathSqlResource resource, Map<String, Object> params) {
		return MirageServiceManager.getMirageService().useService(getDatabase()).withMirageCache()
				.queryFirstRecord(resource, params);
	}

	@Override
	public Record queryRecordWithCache(ClasspathSqlResource resource) {
		return queryRecordWithCache(resource, null);
	}

	@Override
	public List<Record> queryRecordsWithCache(ClasspathSqlResource resource, Map<String, Object> params) {
		return MirageServiceManager.getMirageService().useService(getDatabase()).withMirageCache()
				.queryForRecords(resource, params);
	}

	@Override
	public List<Record> queryRecordsWithCache(ClasspathSqlResource resource) {
		return queryRecordsWithCache(resource, null);
	}

}
