package cn.sylinx.hbatis.ext.mirage.repository;

import java.util.List;
import java.util.Map;

import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.ext.common.repository.CommonRepository;
import cn.sylinx.hbatis.ext.res.ClasspathSqlResource;

/**
 * 基本crud
 * 
 * @author han
 *
 */
public interface Repository extends CommonRepository {

	/**
	 * 插入操作
	 * 
	 * @param resource
	 * @param params
	 * @return
	 */
	int insert(ClasspathSqlResource resource, Map<String, Object> params);

	/**
	 * 插入操作
	 * 
	 * @param resource
	 * @return
	 */
	int insert(ClasspathSqlResource resource);

	/**
	 * 查询单个对象
	 * 
	 * @param resource
	 * @param params
	 * @return
	 */
	Record queryRecord(ClasspathSqlResource resource, Map<String, Object> params);

	/**
	 * 查询单个对象
	 * 
	 * @param resource
	 * @return
	 */
	Record queryRecord(ClasspathSqlResource resource);

	/**
	 * 查询对象列表
	 * 
	 * @param resource
	 * @param params
	 * @return
	 */
	List<Record> queryRecords(ClasspathSqlResource resource, Map<String, Object> params);

	/**
	 * 查询对象列表
	 * 
	 * @param resource
	 * @return
	 */
	List<Record> queryRecords(ClasspathSqlResource resource);

	
	/**
	 * 更新操作
	 * 
	 * @param resource
	 * @param params
	 * @return
	 */
	int update(ClasspathSqlResource resource, Map<String, Object> params);

	/**
	 * 更新操作
	 * 
	 * @param resource
	 * @return
	 */
	int update(ClasspathSqlResource resource);

	/**
	 * 更新并获取主键
	 * 
	 * @param resource
	 * @param params
	 * @return
	 */
	Object updateWithReturnPk(ClasspathSqlResource resource, Map<String, Object> params);

	/**
	 * 删除操作
	 * 
	 * @param resource
	 * @param params
	 * @return
	 */
	int delete(ClasspathSqlResource resource, Map<String, Object> params);

	/**
	 * 删除操作
	 * 
	 * @param resource
	 * @return
	 */
	int delete(ClasspathSqlResource resource);

	/**
	 * 查询单个对象
	 * 
	 * @param resource
	 * @param params
	 * @return
	 */
	Record queryRecordWithCache(ClasspathSqlResource resource, Map<String, Object> params);

	/**
	 * 查询单个对象
	 * 
	 * @param resource
	 * @return
	 */
	Record queryRecordWithCache(ClasspathSqlResource resource);

	/**
	 * 查询对象列表
	 * 
	 * @param resource
	 * @param params
	 * @return
	 */
	List<Record> queryRecordsWithCache(ClasspathSqlResource resource, Map<String, Object> params);

	/**
	 * 查询对象列表
	 * 
	 * @param resource
	 * @return
	 */
	List<Record> queryRecordsWithCache(ClasspathSqlResource resource);

}
