/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.type;

import cn.sylinx.hbatis.type.handler.BigDecimalTypeHandler;
import cn.sylinx.hbatis.type.handler.BigIntegerTypeHandler;
import cn.sylinx.hbatis.type.handler.BlobInputStreamTypeHandler;
import cn.sylinx.hbatis.type.handler.BooleanTypeHandler;
import cn.sylinx.hbatis.type.handler.ByteArrayTypeHandler;
import cn.sylinx.hbatis.type.handler.ByteObjectArrayTypeHandler;
import cn.sylinx.hbatis.type.handler.ByteTypeHandler;
import cn.sylinx.hbatis.type.handler.CharacterTypeHandler;
import cn.sylinx.hbatis.type.handler.ClobReaderTypeHandler;
import cn.sylinx.hbatis.type.handler.DateTypeHandler;
import cn.sylinx.hbatis.type.handler.DoubleTypeHandler;
import cn.sylinx.hbatis.type.handler.EnumTypeHandler;
import cn.sylinx.hbatis.type.handler.FloatTypeHandler;
import cn.sylinx.hbatis.type.handler.InstantTypeHandler;
import cn.sylinx.hbatis.type.handler.IntegerTypeHandler;
import cn.sylinx.hbatis.type.handler.JapaneseDateTypeHandler;
import cn.sylinx.hbatis.type.handler.LocalDateTimeTypeHandler;
import cn.sylinx.hbatis.type.handler.LocalDateTypeHandler;
import cn.sylinx.hbatis.type.handler.LocalTimeTypeHandler;
import cn.sylinx.hbatis.type.handler.LongTypeHandler;
import cn.sylinx.hbatis.type.handler.MonthTypeHandler;
import cn.sylinx.hbatis.type.handler.ObjectTypeHandler;
import cn.sylinx.hbatis.type.handler.OffsetDateTimeTypeHandler;
import cn.sylinx.hbatis.type.handler.OffsetTimeTypeHandler;
import cn.sylinx.hbatis.type.handler.ShortTypeHandler;
import cn.sylinx.hbatis.type.handler.SqlDateTypeHandler;
import cn.sylinx.hbatis.type.handler.SqlTimeTypeHandler;
import cn.sylinx.hbatis.type.handler.SqlTimestampTypeHandler;
import cn.sylinx.hbatis.type.handler.StringTypeHandler;
import cn.sylinx.hbatis.type.handler.TypeHandler;
import cn.sylinx.hbatis.type.handler.TypeReference;
import cn.sylinx.hbatis.type.handler.UnknownTypeHandler;
import cn.sylinx.hbatis.type.handler.YearMonthTypeHandler;
import cn.sylinx.hbatis.type.handler.YearTypeHandler;
import cn.sylinx.hbatis.type.handler.ZonedDateTimeTypeHandler;
import cn.sylinx.hbatis.type.registrar.TypeHandlerRegistrar;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.JapaneseDate;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public final class TypeHandlerRegistry {
    private final Map<Type, TypeHandler<?>> TYPE_HANDLER_MAP = new ConcurrentHashMap();
    private final UnknownTypeHandler UNKNOWN_TYPE_HANDLER = new UnknownTypeHandler();
    private static TypeHandlerRegistry instance = null;

    public static TypeHandlerRegistry getInstance() {
        if (instance == null) {
            TypeHandlerRegistry.initInstance();
        }
        return instance;
    }

    private static synchronized void initInstance() {
        if (instance == null) {
            instance = new TypeHandlerRegistry();
        }
    }

    private void registerSystemTypeHandler() {
        this.register(Boolean.class, new BooleanTypeHandler());
        this.register(Boolean.TYPE, new BooleanTypeHandler());
        this.register(Byte.class, new ByteTypeHandler());
        this.register(Byte.TYPE, new ByteTypeHandler());
        this.register(Short.class, new ShortTypeHandler());
        this.register(Short.TYPE, new ShortTypeHandler());
        this.register(Integer.class, new IntegerTypeHandler());
        this.register(Integer.TYPE, new IntegerTypeHandler());
        this.register(Long.class, new LongTypeHandler());
        this.register(Long.TYPE, new LongTypeHandler());
        this.register(Float.class, new FloatTypeHandler());
        this.register(Float.TYPE, new FloatTypeHandler());
        this.register(Double.class, new DoubleTypeHandler());
        this.register(Double.TYPE, new DoubleTypeHandler());
        this.register(Reader.class, new ClobReaderTypeHandler());
        this.register(String.class, new StringTypeHandler());
        this.register(BigInteger.class, new BigIntegerTypeHandler());
        this.register(BigDecimal.class, new BigDecimalTypeHandler());
        this.register(InputStream.class, new BlobInputStreamTypeHandler());
        this.register(Byte[].class, new ByteObjectArrayTypeHandler());
        this.register(byte[].class, new ByteArrayTypeHandler());
        this.register(Object.class, new ObjectTypeHandler());
        this.register(java.util.Date.class, new DateTypeHandler());
        this.register(Date.class, new SqlDateTypeHandler());
        this.register(Time.class, new SqlTimeTypeHandler());
        this.register(Timestamp.class, new SqlTimestampTypeHandler());
        this.register(Instant.class, new InstantTypeHandler());
        this.register(LocalDateTime.class, new LocalDateTimeTypeHandler());
        this.register(LocalDate.class, new LocalDateTypeHandler());
        this.register(LocalTime.class, new LocalTimeTypeHandler());
        this.register(OffsetDateTime.class, new OffsetDateTimeTypeHandler());
        this.register(OffsetTime.class, new OffsetTimeTypeHandler());
        this.register(ZonedDateTime.class, new ZonedDateTimeTypeHandler());
        this.register(Month.class, new MonthTypeHandler());
        this.register(Year.class, new YearTypeHandler());
        this.register(YearMonth.class, new YearMonthTypeHandler());
        this.register(JapaneseDate.class, new JapaneseDateTypeHandler());
        this.register(Character.class, new CharacterTypeHandler());
        this.register(Character.TYPE, new CharacterTypeHandler());
    }

    private TypeHandlerRegistry() {
        this.registerSystemTypeHandler();
        this.registerExtTypeHandler();
    }

    private void registerExtTypeHandler() {
        ServiceLoader<TypeHandlerRegistrar> sl = ServiceLoader.load(TypeHandlerRegistrar.class);
        if (sl != null) {
            Iterator<TypeHandlerRegistrar> thr = sl.iterator();
            while (thr.hasNext()) {
                Map<Class<?>, TypeHandler<?>> mappedTypeHandlers = thr.next().mappedTypeHandlers();
                if (mappedTypeHandlers == null || mappedTypeHandlers.isEmpty()) continue;
                mappedTypeHandlers.entrySet().forEach(kv -> this.register((Type)kv.getKey(), (TypeHandler)kv.getValue()));
            }
        }
    }

    public <T> TypeHandler<T> getTypeHandler(Class<T> type) {
        TypeHandler<?> handler = this.TYPE_HANDLER_MAP.get(type);
        if (handler == null && type != null && type instanceof Class && Enum.class.isAssignableFrom(type)) {
            handler = new EnumTypeHandler<T>(type);
        }
        return handler;
    }

    <T> void register(TypeHandler<T> typeHandler) {
        TypeReference typeReference = (TypeReference)((Object)typeHandler);
        this.register(typeReference.getRawType(), typeHandler);
    }

    <T> void register(Class<T> javaType, TypeHandler<? extends T> typeHandler) {
        this.register((Type)javaType, typeHandler);
    }

    <T> void register(Type javaType, TypeHandler<? extends T> typeHandler) {
        this.TYPE_HANDLER_MAP.put(javaType, typeHandler);
    }

    <T> void register(TypeReference<T> javaTypeReference, TypeHandler<? extends T> handler) {
        this.register(javaTypeReference.getRawType(), handler);
    }

    public UnknownTypeHandler getUnknownTypeHandler() {
        return this.UNKNOWN_TYPE_HANDLER;
    }
}

