/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.plugin.optlock;

import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.db.mapper.anno.Version;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.optlock.OptimisticLockInsert;
import cn.sylinx.hbatis.plugin.optlock.OptimisticLockUpdate;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;

public enum OptimisticLockWrapper {
    ME;

    private boolean enable = false;

    public boolean isEnable() {
        return this.enable;
    }

    void setEnable(boolean enable) {
        this.enable = enable;
    }

    public static <T> OptimisticLockInsert parseOptimisticLockInsert(T t) {
        if (!OptimisticLockWrapper.ME.enable) {
            return null;
        }
        if (t == null) {
            return null;
        }
        Field f = ModelBuilder.getVersionField(t.getClass());
        if (f == null) {
            return null;
        }
        Number initVersionValue = OptimisticLockWrapper.getInitVersionValue(f.getType());
        if (initVersionValue == null) {
            return null;
        }
        OptimisticLockInsert oli = new OptimisticLockInsert();
        oli.setVersionField(f);
        oli.setVersionFieldAttr(f.getName());
        oli.setInitVersionValue(initVersionValue);
        return oli;
    }

    public static <T> OptimisticLockUpdate parseOptimisticLockUpdate(T t) {
        if (!OptimisticLockWrapper.ME.enable) {
            return null;
        }
        if (t == null) {
            return null;
        }
        Field f = ModelBuilder.getVersionField(t.getClass());
        if (f == null) {
            return null;
        }
        Number versionValue = null;
        try {
            f.setAccessible(true);
            versionValue = (Number)f.get(t);
        }
        catch (Exception e) {
            GLog.error("getVersionField error", e);
        }
        if (versionValue == null) {
            return null;
        }
        Number newVersionValue = OptimisticLockWrapper.getNewVersionValue(versionValue);
        if (newVersionValue == null) {
            return null;
        }
        OptimisticLockUpdate olu = new OptimisticLockUpdate();
        olu.setNewVersionValue(newVersionValue);
        olu.setOldVersionValue(versionValue);
        olu.setVersionField(f);
        olu.setVersionFieldAttr(f.getName());
        return olu;
    }

    private static Number getNewVersionValue(Number oldVersionValue) {
        Class<?> clz = oldVersionValue.getClass();
        if (clz == Version.VERSION_TYPE_INTEGER || clz == Version.VERSION_TYPE_INTEGER_PRIMARY) {
            return new Integer((Integer)oldVersionValue + 1);
        }
        if (clz == Version.VERSION_TYPE_LONG || clz == Version.VERSION_TYPE_LONG_PRIMARY) {
            return new Long((Long)oldVersionValue + 1L);
        }
        if (clz == Version.VERSION_TYPE_BIGINTEGER) {
            return ((BigInteger)oldVersionValue).add(new BigInteger("1"));
        }
        if (clz == Version.VERSION_TYPE_BIGDECIMAL) {
            return ((BigDecimal)oldVersionValue).add(new BigDecimal("1"));
        }
        return null;
    }

    private static Number getInitVersionValue(Class<?> clz) {
        if (clz == Version.VERSION_TYPE_INTEGER || clz == Version.VERSION_TYPE_INTEGER_PRIMARY) {
            return new Integer(1);
        }
        if (clz == Version.VERSION_TYPE_LONG || clz == Version.VERSION_TYPE_LONG_PRIMARY) {
            return new Long(1L);
        }
        if (clz == Version.VERSION_TYPE_BIGINTEGER) {
            return new BigInteger("1");
        }
        if (clz == Version.VERSION_TYPE_BIGDECIMAL) {
            return new BigDecimal("1");
        }
        return null;
    }
}

