/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.plugin.cache;

import cn.sylinx.hbatis.db.cache.ICacheKit;
import cn.sylinx.hbatis.db.cache.IDataLoader;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.cache.GuavaCacheConfig;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

class GuavaCacheKit
implements ICacheKit {
    private Cache<String, Optional<Object>> cache;

    public GuavaCacheKit() {
        this(new GuavaCacheConfig());
    }

    public GuavaCacheKit(GuavaCacheConfig guavaCacheConfig) {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(guavaCacheConfig.getExpireAfterWrite())).maximumSize(guavaCacheConfig.getMaximumSize()).build();
    }

    @Override
    public boolean isInited() {
        return true;
    }

    @Override
    public <T> T get(String cacheKey, IDataLoader dataLoader) {
        Callable<Optional> callable = () -> {
            GLog.debug("loaded from db, cache key: {} ", cacheKey);
            return Optional.ofNullable(dataLoader.load());
        };
        try {
            Optional wrappedObject = (Optional)this.cache.get((Object)cacheKey, callable);
            return wrappedObject.isPresent() ? (T)wrappedObject.get() : null;
        }
        catch (ExecutionException e) {
            GLog.error("get cache error", e);
            return null;
        }
    }
}

