/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.plugin;

import cn.sylinx.hbatis.exception.HbatisException;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.IPlugin;
import java.util.List;

public class PluginStarter {
    private List<IPlugin> pluginList = null;
    private Object[] params = null;

    public PluginStarter() {
    }

    public PluginStarter(List<IPlugin> pluginList) {
        this.pluginList = pluginList;
    }

    public PluginStarter(List<IPlugin> pluginList, Object[] params) {
        this.pluginList = pluginList;
        this.params = params;
    }

    public void setPluginList(List<IPlugin> pluginList) {
        this.pluginList = pluginList;
    }

    public boolean start() {
        if (this.pluginList != null) {
            for (IPlugin plugin : this.pluginList) {
                try {
                    boolean success = plugin.start(this.params);
                    if (!success) {
                        String message = "Plugin start error: " + plugin.getClass().getName();
                        GLog.error(message, new Object[0]);
                        throw new HbatisException(message);
                    }
                    GLog.info("Plugin[{}] started", plugin.getClass().getName());
                }
                catch (Exception e) {
                    String message = "Plugin start error: " + plugin.getClass().getName() + ". \n" + e.getMessage();
                    GLog.error(message, e);
                    throw new HbatisException(message, e);
                }
            }
        }
        return true;
    }

    public boolean stop() {
        if (this.pluginList != null) {
            for (IPlugin plugin : this.pluginList) {
                try {
                    boolean success = plugin.stop();
                    if (success) continue;
                    String message = "Plugin stop error: " + plugin.getClass().getName();
                    GLog.error(message, new Object[0]);
                    throw new HbatisException(message);
                }
                catch (Exception e) {
                    String message = "Plugin stop error: " + plugin.getClass().getName() + ". \n" + e.getMessage();
                    GLog.error(message, e);
                    throw new HbatisException(message, e);
                }
            }
        }
        return false;
    }
}

