/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.io;

import cn.sylinx.hbatis.io.ClassLoaderWrapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;

public class Resources {
    private static ClassLoaderWrapper classLoaderWrapper = new ClassLoaderWrapper();
    private static Charset charset;

    Resources() {
    }

    public static ClassLoader getDefaultClassLoader() {
        return Resources.classLoaderWrapper.defaultClassLoader;
    }

    public static void setDefaultClassLoader(ClassLoader defaultClassLoader) {
        Resources.classLoaderWrapper.defaultClassLoader = defaultClassLoader;
    }

    public static URL getResourceURL(String resource) throws IOException {
        return Resources.getResourceURL(null, resource);
    }

    public static List<URL> getResourceURLs(String resource) throws IOException {
        return Resources.getResourceURLs(null, resource);
    }

    public static URL getResourceURL(ClassLoader loader, String resource) throws IOException {
        URL url = classLoaderWrapper.getResourceAsURL(resource, loader);
        if (url == null) {
            throw new IOException("Could not find resource " + resource);
        }
        return url;
    }

    public static List<URL> getResourceURLs(ClassLoader loader, String resource) throws IOException {
        List<URL> urlList;
        if (resource.startsWith("/")) {
            resource = resource.substring(1, resource.length());
        }
        if ((urlList = classLoaderWrapper.getResourceAsURLs(resource, loader)) == null || urlList.isEmpty()) {
            throw new IOException("Could not find resource " + resource);
        }
        return urlList;
    }

    public static InputStream getResourceAsStream(String resource) throws IOException {
        return Resources.getResourceAsStream(null, resource);
    }

    public static InputStream getResourceAsStream(ClassLoader loader, String resource) throws IOException {
        InputStream in = classLoaderWrapper.getResourceAsStream(resource, loader);
        if (in == null) {
            throw new IOException("Could not find resource " + resource);
        }
        return in;
    }

    public static Properties getResourceAsProperties(String resource) throws IOException {
        Properties props = new Properties();
        InputStream in = Resources.getResourceAsStream(resource);
        props.load(in);
        in.close();
        return props;
    }

    public static Properties getResourceAsProperties(ClassLoader loader, String resource) throws IOException {
        Properties props = new Properties();
        InputStream in = Resources.getResourceAsStream(loader, resource);
        props.load(in);
        in.close();
        return props;
    }

    public static Reader getResourceAsReader(String resource) throws IOException {
        InputStreamReader reader = charset == null ? new InputStreamReader(Resources.getResourceAsStream(resource)) : new InputStreamReader(Resources.getResourceAsStream(resource), charset);
        return reader;
    }

    public static Reader getResourceAsReader(ClassLoader loader, String resource) throws IOException {
        InputStreamReader reader = charset == null ? new InputStreamReader(Resources.getResourceAsStream(loader, resource)) : new InputStreamReader(Resources.getResourceAsStream(loader, resource), charset);
        return reader;
    }

    public static File getResourceAsFile(String resource) throws IOException {
        return new File(Resources.getResourceURL(resource).getFile());
    }

    public static File getResourceAsFile(ClassLoader loader, String resource) throws IOException {
        return new File(Resources.getResourceURL(loader, resource).getFile());
    }

    public static InputStream getUrlAsStream(String urlString) throws IOException {
        URL url = new URL(urlString);
        URLConnection conn = url.openConnection();
        return conn.getInputStream();
    }

    public static Reader getUrlAsReader(String urlString) throws IOException {
        InputStreamReader reader = charset == null ? new InputStreamReader(Resources.getUrlAsStream(urlString)) : new InputStreamReader(Resources.getUrlAsStream(urlString), charset);
        return reader;
    }

    public static Properties getUrlAsProperties(String urlString) throws IOException {
        Properties props = new Properties();
        InputStream in = Resources.getUrlAsStream(urlString);
        props.load(in);
        in.close();
        return props;
    }

    public static Class<?> classForName(String className) throws ClassNotFoundException {
        return classLoaderWrapper.classForName(className);
    }

    public static Charset getCharset() {
        return charset;
    }

    public static void setCharset(Charset charset) {
        Resources.charset = charset;
    }
}

