/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.transaction;

import cn.sylinx.hbatis.db.common.ITransaction;
import cn.sylinx.hbatis.exception.ErrorCodeRecordable;
import cn.sylinx.hbatis.exception.TransactionException;
import cn.sylinx.hbatis.ext.common.repository.DaoService;
import cn.sylinx.hbatis.ext.ctxds.DynamicDatasourceProvider;
import cn.sylinx.hbatis.ext.starter.util.DaoHelper;
import cn.sylinx.hbatis.ext.transaction.Transactional;
import cn.sylinx.hbatis.kit.Ret;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.log.GLog;
import java.sql.SQLException;

public abstract class AbstractTransactionalSupport {
    protected Object transaction(final Transactional trans, final Invoker invoker) {
        ITransaction transaction;
        String truelyDatasource = trans.dynamic() ? DynamicDatasourceProvider.create().getDatasource() : trans.datasource();
        DaoService daoService = StrKit.isBlank(truelyDatasource) ? DaoHelper.create() : DaoHelper.create(truelyDatasource);
        Ret r = daoService.transactionWithReturn(transaction = new ITransaction(){

            @Override
            public Ret run() throws SQLException {
                Ret result = Ret.success();
                try {
                    result.setData(invoker.invoke());
                }
                catch (Throwable e) {
                    GLog.error("proceed error", e);
                    String msg = StrKit.isBlank(e.getMessage()) || e.getMessage() == "null" ? "\u6267\u884c\u4e8b\u52a1\u5f02\u5e38" : e.getMessage();
                    int code = 500;
                    if (ErrorCodeRecordable.class.isAssignableFrom(e.getClass())) {
                        code = ((ErrorCodeRecordable)((Object)e)).getCode();
                    }
                    return Ret.error(code, msg, e);
                }
                return result;
            }

            @Override
            public Integer transactionIsolation() {
                int ti = trans.transactionIsolation();
                if (ti == 0 || ti == 1 || ti == 2 || ti == 4 || ti == 8) {
                    return ti;
                }
                return ITransaction.super.transactionIsolation();
            }
        });
        if (r.isSuccess()) {
            if (r.isNestedTransaction()) {
                Ret ret = (Ret)r.getData();
                if (!ret.isSuccess()) {
                    throw new TransactionException(ret.getCode(), ret.getError(), ret.getCause());
                }
                return ret.getData();
            }
            return r.getData();
        }
        throw new TransactionException(r.getCode(), r.getError(), r.getCause());
    }

    protected static interface Invoker {
        public Object invoke() throws Throwable;
    }
}

