/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.tool;

import cn.sylinx.hbatis.db.dialect.DbType;
import cn.sylinx.hbatis.ext.tool.MysqlRepositoryUtil;
import cn.sylinx.hbatis.ext.tool.OracleRepositoryUtil;
import cn.sylinx.hbatis.ext.tool.SqlserverRepositoryUtil;
import java.util.Objects;

public class RepositoryTools {
    private static final RepositoryTools instance = new RepositoryTools();

    private RepositoryTools() {
    }

    public static RepositoryTools getInstance() {
        return instance;
    }

    public String generateTableDdlSql(DbType dbType, Class<?> ... clz) {
        Objects.requireNonNull(dbType);
        switch (dbType) {
            case MYSQL: {
                return this.generateMysqlTableDDL(clz);
            }
            case ORACLE: {
                return this.generateOracleTableDDL(clz);
            }
            case SQLSERVER: {
                return this.generateSqlserverTableDDL(clz);
            }
        }
        throw new UnsupportedOperationException("\u8be5\u6570\u636e\u5e93" + (Object)((Object)dbType) + "\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
    }

    public String generateAddTableColumnDDL(DbType dbType, Class<?> clz, String prop) {
        Objects.requireNonNull(dbType);
        switch (dbType) {
            case MYSQL: {
                return this.generateMysqlAddTableColumnDDL(clz, prop);
            }
            case ORACLE: {
                return this.generateOracleAddTableColumnDDL(clz, prop);
            }
            case SQLSERVER: {
                return this.generateSqlserverAddTableColumnDDL(clz, prop);
            }
        }
        throw new UnsupportedOperationException("\u8be5\u6570\u636e\u5e93" + (Object)((Object)dbType) + "\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
    }

    public String generateModifyTableColumnDDL(DbType dbType, Class<?> clz, String prop) {
        Objects.requireNonNull(dbType);
        switch (dbType) {
            case MYSQL: {
                return this.generateMysqlModifyTableColumnDDL(clz, prop);
            }
            case ORACLE: {
                return this.generateOracleModifyTableColumnDDL(clz, prop);
            }
            case SQLSERVER: {
                return this.generateSqlserverModifyTableColumnDDL(clz, prop);
            }
        }
        throw new UnsupportedOperationException("\u8be5\u6570\u636e\u5e93" + (Object)((Object)dbType) + "\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
    }

    private String generateSqlserverModifyTableColumnDDL(Class<?> clz, String prop) {
        return new SqlserverRepositoryUtil(clz).generateModifyTableColumnDDL(prop);
    }

    private String generateSqlserverAddTableColumnDDL(Class<?> clz, String prop) {
        return new SqlserverRepositoryUtil(clz).generateAddTableColumnDDL(prop);
    }

    private String generateSqlserverTableDDL(Class<?> ... clzArray) {
        return SqlserverRepositoryUtil.generateSql(clzArray);
    }

    private String generateMysqlTableDDL(Class<?> ... clzArray) {
        return MysqlRepositoryUtil.generateSql(clzArray);
    }

    private String generateOracleTableDDL(Class<?> ... clzArray) {
        return OracleRepositoryUtil.generateSql(clzArray);
    }

    private String generateMysqlAddTableColumnDDL(Class<?> clz, String prop) {
        return new MysqlRepositoryUtil(clz).generateAddTableColumnDDL(prop);
    }

    private String generateOracleAddTableColumnDDL(Class<?> clz, String prop) {
        return new OracleRepositoryUtil(clz).generateAddTableColumnDDL(prop);
    }

    private String generateMysqlModifyTableColumnDDL(Class<?> clz, String prop) {
        return new MysqlRepositoryUtil(clz).generateModifyTableColumnDDL(prop);
    }

    private String generateOracleModifyTableColumnDDL(Class<?> clz, String prop) {
        return new OracleRepositoryUtil(clz).generateModifyTableColumnDDL(prop);
    }
}

