/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.tool;

import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.db.mapper.anno.BlobType;
import cn.sylinx.hbatis.db.mapper.anno.ColumnDesc;
import cn.sylinx.hbatis.db.mapper.anno.TextType;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.plugin.model.ModelFabric;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OracleRepositoryUtil {
    public static final String ORACLE_SINGLE_QUOTES = "\"";
    public static final String ORACLE_DROP_TEMPLATE = "DROP TABLE IF EXISTS \"%s\";";
    public static final String ORACLE_CREATE_TEMPLATE = "CREATE TABLE \"%s\" (";
    public static final String ORACLE_ROW_PK = " CONSTRAINT \"P_%s\" PRIMARY KEY(\"ID\") ";
    public static final String ORACLE_ALTER_TABLE = "ALTER TABLE \"%s\"";
    public static final String ORACLE_ALTER_TABLE_ADD_COL = "ADD";
    public static final String ORACLE_ALTER_TABLE_MODIFY_COL = "MODIFY";
    protected static final Map<String, String> ORACLE_JAVA_JDBC_MAP = new HashMap<String, String>();
    private Class<? extends Object> clz;
    private List<Field> fields;
    private String tableName;
    private String tableDesc;
    private Map<String, String> attrMapping;
    private Map<String, ColumnDesc> fieldDesc;
    private Map<String, Field> fieldMap;

    public OracleRepositoryUtil(Class<? extends Object> clz) {
        this.clz = clz;
        if (clz == null) {
            throw new RuntimeException("clz is null or path is null");
        }
        ModelFabric modelFabric = ModelBuilder.getModelFabric(this.clz);
        this.fields = modelFabric.getFields();
        this.tableName = modelFabric.getTableName().toUpperCase();
        this.tableDesc = modelFabric.getTable() == null ? modelFabric.getTableName() : modelFabric.getTable().desc();
        this.attrMapping = modelFabric.getAttrMapping();
        this.fieldDesc = modelFabric.getFieldDesc();
        this.fieldMap = modelFabric.getFieldMap();
    }

    public String generateAddTableColumnDDL(String prop) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(ORACLE_ALTER_TABLE, this.tableName)).append(" ").append(ORACLE_ALTER_TABLE_ADD_COL).append(" ");
        String propertyName = prop;
        Field field = this.fieldMap.get(prop);
        ColumnDesc cd = this.fieldDesc.get(propertyName);
        String javaType = this.getFieldType(field);
        String jdbcType = this.toJdbcType(javaType);
        String columName = this.attrMapping.get(propertyName);
        if (StrKit.isBlank(columName)) {
            columName = propertyName;
        }
        columName = columName.toUpperCase();
        String column_template = "\"%s\" %s;\n";
        int len = 0;
        int precision = 0;
        boolean blob = false;
        boolean text = false;
        BlobType bt = BlobType.MIN;
        TextType tt = TextType.MIN;
        String dv = "";
        String comment = null;
        boolean nullable = true;
        if (cd != null) {
            len = cd.len();
            precision = cd.precision();
            comment = cd.desc();
            nullable = cd.nullable();
            blob = cd.blob();
            text = cd.text();
            bt = cd.blobType();
            tt = cd.textType();
            dv = cd.defaultValue();
        }
        if (blob) {
            String key = javaType + "." + bt.name();
            jdbcType = this.toJdbcType(key);
        } else if (text) {
            String key = javaType + "." + tt.name();
            jdbcType = this.toJdbcType(key);
        } else if (len > 0) {
            jdbcType = jdbcType + (precision == 0 ? "(" + len + ")" : "(" + len + "," + precision + ")");
        } else if ("VARCHAR2".equals(jdbcType)) {
            jdbcType = jdbcType + "(50)";
        }
        jdbcType = StrKit.isNotBlank(dv) ? jdbcType + " DEFAULT " + dv : jdbcType + (nullable ? " DEFAULT NULL" : " NOT NULL");
        if ("id".equalsIgnoreCase(propertyName)) {
            jdbcType = " NUMBER NOT NULL";
        }
        sb.append(String.format(column_template, columName, jdbcType));
        if (StrKit.isNotBlank(comment)) {
            sb.append("COMMENT ON COLUMN \"").append(this.tableName).append("\".\"").append(columName).append("\" IS '").append(comment).append("';\n");
        }
        return sb.toString();
    }

    public String generateModifyTableColumnDDL(String prop) {
        if ("id".equalsIgnoreCase(prop)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(ORACLE_ALTER_TABLE, this.tableName)).append(" ").append(ORACLE_ALTER_TABLE_MODIFY_COL).append(" ");
        String propertyName = prop;
        Field field = this.fieldMap.get(prop);
        ColumnDesc cd = this.fieldDesc.get(propertyName);
        String javaType = this.getFieldType(field);
        String jdbcType = this.toJdbcType(javaType);
        String columName = this.attrMapping.get(propertyName);
        if (StrKit.isBlank(columName)) {
            columName = propertyName;
        }
        columName = columName.toUpperCase();
        String column_template = "\"%s\" %s;\n";
        int len = 0;
        int precision = 0;
        boolean blob = false;
        boolean text = false;
        BlobType bt = BlobType.MIN;
        TextType tt = TextType.MIN;
        String comment = null;
        if (cd != null) {
            len = cd.len();
            precision = cd.precision();
            comment = cd.desc();
            blob = cd.blob();
            text = cd.text();
            bt = cd.blobType();
            tt = cd.textType();
        }
        if (blob) {
            String key = javaType + "." + bt.name();
            jdbcType = this.toJdbcType(key);
        } else if (text) {
            String key = javaType + "." + tt.name();
            jdbcType = this.toJdbcType(key);
        } else if (len > 0) {
            jdbcType = jdbcType + (precision == 0 ? "(" + len + ")" : "(" + len + "," + precision + ")");
        } else if ("VARCHAR2".equals(jdbcType)) {
            jdbcType = jdbcType + "(50)";
        }
        sb.append(String.format(column_template, columName, jdbcType));
        if (StrKit.isNotBlank(comment)) {
            sb.append("COMMENT ON COLUMN \"").append(this.tableName).append("\".\"").append(columName).append("\" IS '").append(comment).append("';\n");
        }
        return sb.toString();
    }

    public static String generateSql(Class<?> ... clzArray) {
        if (clzArray == null || clzArray.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Class<?> clz : clzArray) {
            sb.append(new OracleRepositoryUtil(clz).generateSql()).append("\n");
        }
        return sb.toString();
    }

    public String generateSql() {
        StringBuilder commentSb = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(ORACLE_CREATE_TEMPLATE, this.tableName)).append("\n");
        ArrayList<Field> sortField = new ArrayList<Field>();
        for (Field field : this.fields) {
            if (field.getName().equals("id")) {
                sortField.add(0, field);
                continue;
            }
            sortField.add(field);
        }
        for (Field field : sortField) {
            sb.append(this.generateSingleColumn(field, commentSb)).append("\n");
        }
        sb.append(String.format(ORACLE_ROW_PK, this.tableName)).append("\n");
        sb.append(");\n");
        if (StrKit.isNotBlank(this.tableDesc)) {
            commentSb.append("COMMENT ON TABLE \"" + this.tableName + "\" IS '").append(this.tableDesc).append("';\n");
        }
        sb.append((CharSequence)commentSb);
        return sb.toString();
    }

    private String generateSingleColumn(Field field, StringBuilder commentSb) {
        StringBuilder sb = new StringBuilder();
        String propertyName = field.getName();
        ColumnDesc cd = this.fieldDesc.get(propertyName);
        String javaType = this.getFieldType(field);
        String jdbcType = this.toJdbcType(javaType);
        String columName = this.attrMapping.get(propertyName);
        if (StrKit.isBlank(columName)) {
            columName = propertyName;
        }
        columName = columName.toUpperCase();
        String column_template = "\"%s\" %s,";
        int len = 0;
        int precision = 0;
        boolean blob = false;
        boolean text = false;
        BlobType bt = BlobType.MIN;
        TextType tt = TextType.MIN;
        String dv = "";
        String comment = null;
        boolean nullable = true;
        if (cd != null) {
            len = cd.len();
            precision = cd.precision();
            comment = cd.desc();
            nullable = cd.nullable();
            blob = cd.blob();
            text = cd.text();
            bt = cd.blobType();
            tt = cd.textType();
            dv = cd.defaultValue();
        }
        if (blob) {
            String key = javaType + "." + bt.name();
            jdbcType = this.toJdbcType(key);
        } else if (text) {
            String key = javaType + "." + tt.name();
            jdbcType = this.toJdbcType(key);
        } else if (len > 0) {
            jdbcType = jdbcType + (precision == 0 ? "(" + len + ")" : "(" + len + "," + precision + ")");
        } else if ("VARCHAR2".equals(jdbcType)) {
            jdbcType = jdbcType + "(50)";
        }
        jdbcType = StrKit.isNotBlank(dv) ? jdbcType + " DEFAULT " + dv : jdbcType + (nullable ? " DEFAULT NULL" : " NOT NULL");
        if (StrKit.isNotBlank(comment)) {
            commentSb.append("COMMENT ON COLUMN \"").append(this.tableName).append("\".\"").append(columName).append("\" IS '").append(comment).append("';\n");
        }
        if ("id".equalsIgnoreCase(columName)) {
            jdbcType = " NUMBER NOT NULL";
        }
        sb.append(String.format(column_template, columName, jdbcType));
        return sb.toString();
    }

    protected String toJdbcType(String javaType) {
        return ORACLE_JAVA_JDBC_MAP.get(javaType);
    }

    protected String getFieldType(Field field) {
        return field.getType().getName();
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    static {
        ORACLE_JAVA_JDBC_MAP.put("java.util.Date", "DATE");
        ORACLE_JAVA_JDBC_MAP.put("java.lang.String", "VARCHAR2");
        ORACLE_JAVA_JDBC_MAP.put("java.lang.String.MIN", "CLOB");
        ORACLE_JAVA_JDBC_MAP.put("java.lang.String.MEDIUM", "CLOB");
        ORACLE_JAVA_JDBC_MAP.put("java.lang.String.LONG", "CLOB");
        ORACLE_JAVA_JDBC_MAP.put("java.lang.Long", "NUMBER(20)");
        ORACLE_JAVA_JDBC_MAP.put("java.lang.Byte", "NUMBER(3,0)");
        ORACLE_JAVA_JDBC_MAP.put("java.lang.Short", "NUMBER(6,0)");
        ORACLE_JAVA_JDBC_MAP.put("java.math.BigInteger", "NUMBER(20)");
        ORACLE_JAVA_JDBC_MAP.put("java.math.BigDecimal", "NUMBER");
        ORACLE_JAVA_JDBC_MAP.put("java.lang.Integer", "NUMBER(10,0)");
        ORACLE_JAVA_JDBC_MAP.put("java.lang.Float", "NUMBER(12,3)");
        ORACLE_JAVA_JDBC_MAP.put("java.lang.Double", "NUMBER(16,3)");
        ORACLE_JAVA_JDBC_MAP.put("java.lang.Boolean", "NUMBER(1,0)");
        ORACLE_JAVA_JDBC_MAP.put("[B", "BLOB");
        ORACLE_JAVA_JDBC_MAP.put("[B.MIN", "BLOB");
        ORACLE_JAVA_JDBC_MAP.put("[B.MEDIUM", "BLOB");
        ORACLE_JAVA_JDBC_MAP.put("[B.LONG", "BLOB");
    }
}

