/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.tool;

import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.db.mapper.anno.BlobType;
import cn.sylinx.hbatis.db.mapper.anno.ColumnDesc;
import cn.sylinx.hbatis.db.mapper.anno.TextType;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.plugin.model.ModelFabric;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MysqlRepositoryUtil {
    public static final String MYSQL_SINGLE_QUOTES = "`";
    public static final String MYSQL_DROP_TEMPLATE = "DROP TABLE IF EXISTS `%s`";
    public static final String MYSQL_CREATE_TEMPLATE = "CREATE TABLE IF NOT EXISTS `%s` (";
    public static final String MYSQL_ROW_PK = " PRIMARY KEY (`id`) ";
    public static final String MYSQL_ENGINE = ") ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin";
    public static final String MYSQL_ALTER_TABLE = "ALTER TABLE `%s`";
    public static final String MYSQL_ALTER_TABLE_ADD_COL = "ADD COLUMN";
    public static final String MYSQL_ALTER_TABLE_MODIFY_COL = "MODIFY COLUMN";
    protected static final Map<String, String> MYSQL_JAVA_JDBC_MAP = new HashMap<String, String>();
    private Class<? extends Object> clz;
    private List<Field> fields;
    private String tableName;
    private String tableDesc;
    private Map<String, String> attrMapping;
    private Map<String, ColumnDesc> fieldDesc;
    private Map<String, Field> fieldMap;

    public MysqlRepositoryUtil(Class<? extends Object> clz) {
        this.clz = clz;
        if (clz == null) {
            throw new RuntimeException("clz is null or path is null");
        }
        ModelFabric modelFabric = ModelBuilder.getModelFabric(this.clz);
        this.fields = modelFabric.getFields();
        this.tableName = modelFabric.getTableName();
        this.tableDesc = modelFabric.getTable() == null ? modelFabric.getTableName() : modelFabric.getTable().desc();
        this.attrMapping = modelFabric.getAttrMapping();
        this.fieldDesc = modelFabric.getFieldDesc();
        this.fieldMap = modelFabric.getFieldMap();
    }

    public String generateAddTableColumnDDL(String prop) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(MYSQL_ALTER_TABLE, this.tableName)).append(" ").append(MYSQL_ALTER_TABLE_ADD_COL).append(" ");
        String propertyName = prop;
        Field field = this.fieldMap.get(prop);
        ColumnDesc cd = this.fieldDesc.get(propertyName);
        String javaType = this.getFieldType(field);
        String jdbcType = this.toJdbcType(javaType);
        String columName = this.attrMapping.get(propertyName);
        if (StrKit.isBlank(columName)) {
            columName = propertyName;
        }
        String column_template = "`%s` %s;\n";
        int len = 0;
        int precision = 0;
        boolean blob = false;
        boolean text = false;
        BlobType bt = BlobType.MIN;
        TextType tt = TextType.MIN;
        String dv = "";
        String comment = null;
        boolean nullable = true;
        if (cd != null) {
            len = cd.len();
            precision = cd.precision();
            comment = cd.desc();
            nullable = cd.nullable();
            blob = cd.blob();
            text = cd.text();
            bt = cd.blobType();
            tt = cd.textType();
            dv = cd.defaultValue();
        }
        if (blob) {
            String key = javaType + "." + bt.name();
            jdbcType = this.toJdbcType(key);
        } else if (text) {
            String key = javaType + "." + tt.name();
            jdbcType = this.toJdbcType(key);
        } else if (len > 0) {
            jdbcType = jdbcType + (precision == 0 ? "(" + len + ")" : "(" + len + "," + precision + ")");
        } else if ("varchar".equals(jdbcType)) {
            jdbcType = jdbcType + "(50)";
        }
        jdbcType = StrKit.isNotBlank(dv) ? jdbcType + " DEFAULT " + dv : jdbcType + (nullable ? " DEFAULT NULL" : " NOT NULL");
        if (StrKit.isNotBlank(comment)) {
            jdbcType = jdbcType + " COMMENT '" + comment + "'";
        }
        if ("id".equals(field.getName())) {
            jdbcType = "bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '\u4e3b\u952e'";
        }
        sb.append(String.format(column_template, columName, jdbcType));
        return sb.toString();
    }

    public String generateModifyTableColumnDDL(String prop) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(MYSQL_ALTER_TABLE, this.tableName)).append(" ").append(MYSQL_ALTER_TABLE_MODIFY_COL).append(" ");
        String propertyName = prop;
        Field field = this.fieldMap.get(prop);
        ColumnDesc cd = this.fieldDesc.get(propertyName);
        String javaType = this.getFieldType(field);
        String jdbcType = this.toJdbcType(javaType);
        String columName = this.attrMapping.get(propertyName);
        if (StrKit.isBlank(columName)) {
            columName = propertyName;
        }
        String column_template = "`%s` %s;\n";
        int len = 0;
        int precision = 0;
        boolean blob = false;
        boolean text = false;
        BlobType bt = BlobType.MIN;
        TextType tt = TextType.MIN;
        String dv = "";
        String comment = null;
        boolean nullable = true;
        if (cd != null) {
            len = cd.len();
            precision = cd.precision();
            comment = cd.desc();
            nullable = cd.nullable();
            blob = cd.blob();
            text = cd.text();
            bt = cd.blobType();
            tt = cd.textType();
            dv = cd.defaultValue();
        }
        if (blob) {
            String key = javaType + "." + bt.name();
            jdbcType = this.toJdbcType(key);
        } else if (text) {
            String key = javaType + "." + tt.name();
            jdbcType = this.toJdbcType(key);
        } else if (len > 0) {
            jdbcType = jdbcType + (precision == 0 ? "(" + len + ")" : "(" + len + "," + precision + ")");
        } else if ("varchar".equals(jdbcType)) {
            jdbcType = jdbcType + "(50)";
        }
        jdbcType = StrKit.isNotBlank(dv) ? jdbcType + " DEFAULT " + dv : jdbcType + (nullable ? " DEFAULT NULL" : " NOT NULL");
        if (StrKit.isNotBlank(comment)) {
            jdbcType = jdbcType + " COMMENT '" + comment + "'";
        }
        if ("id".equals(field.getName())) {
            jdbcType = "bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '\u4e3b\u952e'";
        }
        sb.append(String.format(column_template, columName, jdbcType));
        return sb.toString();
    }

    public static String generateSql(Class<?> ... clzArray) {
        if (clzArray == null || clzArray.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Class<?> clz : clzArray) {
            sb.append(new MysqlRepositoryUtil(clz).generateSql()).append("\n");
        }
        return sb.toString();
    }

    public String generateSql() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(MYSQL_CREATE_TEMPLATE, this.tableName)).append("\n");
        ArrayList<Field> sortField = new ArrayList<Field>();
        for (Field field : this.fields) {
            if (field.getName().equals("id")) {
                sortField.add(0, field);
                continue;
            }
            sortField.add(field);
        }
        for (Field field : sortField) {
            sb.append(this.generateSingleColumn(field)).append("\n");
        }
        sb.append(MYSQL_ROW_PK).append("\n");
        sb.append(MYSQL_ENGINE).append(StrKit.isBlank(this.tableDesc) ? "" : " COMMENT='" + this.tableDesc + "'").append(";\n");
        return sb.toString();
    }

    private String generateSingleColumn(Field field) {
        StringBuilder sb = new StringBuilder();
        String propertyName = field.getName();
        ColumnDesc cd = this.fieldDesc.get(propertyName);
        String javaType = this.getFieldType(field);
        String jdbcType = this.toJdbcType(javaType);
        String columName = this.attrMapping.get(propertyName);
        if (StrKit.isBlank(columName)) {
            columName = propertyName;
        }
        String column_template = "`%s` %s,";
        int len = 0;
        int precision = 0;
        boolean blob = false;
        boolean text = false;
        BlobType bt = BlobType.MIN;
        TextType tt = TextType.MIN;
        String dv = "";
        String comment = null;
        boolean nullable = true;
        if (cd != null) {
            len = cd.len();
            precision = cd.precision();
            comment = cd.desc();
            nullable = cd.nullable();
            blob = cd.blob();
            text = cd.text();
            bt = cd.blobType();
            tt = cd.textType();
            dv = cd.defaultValue();
        }
        if (blob) {
            String key = javaType + "." + bt.name();
            jdbcType = this.toJdbcType(key);
        } else if (text) {
            String key = javaType + "." + tt.name();
            jdbcType = this.toJdbcType(key);
        } else if (len > 0) {
            jdbcType = jdbcType + (precision == 0 ? "(" + len + ")" : "(" + len + "," + precision + ")");
        } else if ("varchar".equals(jdbcType)) {
            jdbcType = jdbcType + "(50)";
        }
        jdbcType = StrKit.isNotBlank(dv) ? jdbcType + " DEFAULT " + dv : jdbcType + (nullable ? " DEFAULT NULL" : " NOT NULL");
        if (StrKit.isNotBlank(comment)) {
            jdbcType = jdbcType + " COMMENT '" + comment + "'";
        }
        if ("id".equals(field.getName())) {
            jdbcType = "bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '\u4e3b\u952e'";
        }
        sb.append(String.format(column_template, columName, jdbcType));
        return sb.toString();
    }

    protected String toJdbcType(String javaType) {
        return MYSQL_JAVA_JDBC_MAP.get(javaType);
    }

    protected String getFieldType(Field field) {
        Class<?> clz = field.getType();
        if (clz.isEnum()) {
            return "java.lang.Enum";
        }
        return clz.getName();
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    static {
        MYSQL_JAVA_JDBC_MAP.put("java.io.Serializable", "varchar");
        MYSQL_JAVA_JDBC_MAP.put("java.util.Date", "datetime");
        MYSQL_JAVA_JDBC_MAP.put("java.sql.Date", "datetime");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.String", "varchar");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.String.MIN", "text");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.String.MEDIUM", "mediumtext");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.String.LONG", "longtext");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.Long", "bigint");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.Byte", "tinyint");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.Short", "smallint");
        MYSQL_JAVA_JDBC_MAP.put("java.math.BigInteger", "bigint(20) unsigned");
        MYSQL_JAVA_JDBC_MAP.put("java.math.BigDecimal", "decimal");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.Integer", "int");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.Float", "float");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.Double", "double");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.Boolean", "bit(1)");
        MYSQL_JAVA_JDBC_MAP.put("[B", "blob");
        MYSQL_JAVA_JDBC_MAP.put("[B.MIN", "blob");
        MYSQL_JAVA_JDBC_MAP.put("[B.MEDIUM", "mediumblob");
        MYSQL_JAVA_JDBC_MAP.put("[B.LONG", "longblob");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.Enum", "varchar");
    }
}

