/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.starter.util;

import cn.sylinx.hbatis.db.common.FS;
import cn.sylinx.hbatis.ds.JdbcResourceManager;
import cn.sylinx.hbatis.ext.common.repository.DaoService;
import cn.sylinx.hbatis.ext.common.repository.DaoServiceImpl;
import cn.sylinx.hbatis.ext.common.spi.HbatisServiceManager;
import cn.sylinx.hbatis.ext.proxy.command.CommandRegistry;
import java.util.HashMap;
import java.util.Map;

public final class DaoHelper {
    private static Map<String, DaoService> daoServiceMap = new HashMap<String, DaoService>();

    private static String getDefaultDatasourceName() {
        return HbatisServiceManager.getHbatisService().getDatasourceName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DaoService getDaoService(String datasourceName) {
        DaoService daoService = daoServiceMap.get(datasourceName);
        if (daoService == null) {
            String string = datasourceName.intern();
            synchronized (string) {
                DaoHelper.init(datasourceName);
            }
            daoService = daoServiceMap.get(datasourceName);
        }
        return daoService;
    }

    private static void init(String datasourceName) {
        DaoService daoService = daoServiceMap.get(datasourceName);
        if (daoService == null) {
            daoService = DaoHelper.createDaoService(datasourceName);
            daoServiceMap.put(datasourceName, daoService);
        }
    }

    private static DaoService createDaoService(String datasourceName) {
        return new DaoServiceImpl(datasourceName);
    }

    public static <T> FS<T> createFS(Class<T> clazz) {
        return DaoHelper.createFS(null, clazz);
    }

    public static <T> FS<T> createFS(String dsName, Class<T> clazz) {
        return DaoHelper.create(dsName).createFS(clazz);
    }

    public static DaoService create() {
        return DaoHelper.create(null);
    }

    public static DaoService create(String ds) {
        if (ds == null) {
            return DaoHelper.getDaoService(DaoHelper.getDefaultDatasourceName());
        }
        return DaoHelper.getDaoService(ds);
    }

    public static boolean isInitialized() {
        String defaultJdbcResourceName = null;
        try {
            defaultJdbcResourceName = JdbcResourceManager.get().getDefaultJdbcResourceName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultJdbcResourceName != null;
    }

    public static <T> T getCommand(Class<T> type) {
        return CommandRegistry.INSTANCE.getCommand(type);
    }
}

