/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.starter.springboot;

import cn.sylinx.hbatis.db.dialect.DbType;
import cn.sylinx.hbatis.ds.DataSourceWrapper;
import cn.sylinx.hbatis.exception.HbatisException;
import cn.sylinx.hbatis.ext.starter.pool.DataSourceWrapperFactory;
import cn.sylinx.hbatis.ext.starter.springboot.config.CacheProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.DatasourcePoolProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.DefaultDatasourceProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.ExistDatasourceProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.HbatisProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.ModelpreloadProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.MultiDatasourceProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.ProxyProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.SingleDatasourceProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.SqlResourcePreloadProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.StatementHandlerProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.TransactionProperties;
import cn.sylinx.hbatis.kit.ClassUtil;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.IPlugin;
import cn.sylinx.hbatis.plugin.cache.GuavaCacheConfig;
import cn.sylinx.hbatis.plugin.cache.GuavaCachePlugin;
import cn.sylinx.hbatis.plugin.datasource.DataSourcePlugin;
import cn.sylinx.hbatis.plugin.debug.DebugPlugin;
import cn.sylinx.hbatis.plugin.model.ModelPreloadPlugin;
import cn.sylinx.hbatis.plugin.optlock.OptimisticLockPlugin;
import cn.sylinx.hbatis.plugin.proxy.ProxyPlugin;
import cn.sylinx.hbatis.plugin.sqlres.SqlResourcePreloadPlugin;
import cn.sylinx.hbatis.plugin.statement.StatementHandlerPlugin;
import cn.sylinx.hbatis.plugin.transaction.TransactionIsolationPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

class PluginBuilder {
    private List<IPlugin> pluginList = new ArrayList<IPlugin>();
    private HbatisProperties hbatisProperties;
    private DataSource dataSource;

    public PluginBuilder(HbatisProperties hbatisProperties, DataSource dataSource) {
        this.hbatisProperties = hbatisProperties;
        this.dataSource = dataSource;
        this.check();
    }

    private void check() {
        if (this.hbatisProperties == null) {
            throw new HbatisException("hbatis\u914d\u7f6e\u6587\u4ef6\u4e3a\u7a7a");
        }
        ExistDatasourceProperties edp = this.hbatisProperties.getExistDatasourceProperties();
        if (edp != null && edp.isExist() && this.dataSource == null) {
            throw new HbatisException("\u73b0\u6709\u6570\u636e\u6e90\u4e3a\u7a7a\u503c...");
        }
    }

    public PluginBuilder initModelPreLoadPlugin() {
        String scanPackageList;
        ModelpreloadProperties modelpreloadProperties = this.hbatisProperties.getModelpreloadProperties();
        boolean inited = modelpreloadProperties.isInited();
        if (!inited) {
            return this;
        }
        GLog.debug("ModelPreloadPlugin inited.", new Object[0]);
        ModelPreloadPlugin mp = new ModelPreloadPlugin();
        String acmStrategy = modelpreloadProperties.getAcmStrategy();
        if (StrKit.isNotBlank(acmStrategy)) {
            mp.setAcmStrategyClass(acmStrategy);
        }
        if (StrKit.isNotBlank(scanPackageList = modelpreloadProperties.getScanPackageList())) {
            GLog.debug("ModelPreloadPlugin scanPackageList:{}", scanPackageList);
            String[] pkgArray = scanPackageList.split(",");
            mp.setScanPackageList(Arrays.asList(pkgArray));
        }
        this.pluginList.add(mp);
        return this;
    }

    public PluginBuilder initSqlResourcePreloadPlugin() {
        SqlResourcePreloadProperties srpp = this.hbatisProperties.getSqlResourcePreloadProperties();
        String path = srpp.getSqlpath();
        if (StrKit.isBlank(path)) {
            return this;
        }
        GLog.debug("SqlResourcePreloadPlugin inited.", new Object[0]);
        String[] pathArray = path.split(",");
        List<String> pathList = Arrays.asList(pathArray);
        SqlResourcePreloadPlugin plugin = new SqlResourcePreloadPlugin(pathList);
        this.pluginList.add(plugin);
        return this;
    }

    public PluginBuilder initStatementHandlerPlugin() {
        StatementHandlerProperties shpp = this.hbatisProperties.getStatementHandlerProperties();
        String statementHandlerClass = shpp.getClazz();
        if (StrKit.isBlank(statementHandlerClass)) {
            return this;
        }
        GLog.debug("StatementHandlerPlugin inited.", new Object[0]);
        StatementHandlerPlugin shp = new StatementHandlerPlugin();
        shp.setStatementHandlerClass(statementHandlerClass);
        this.pluginList.add(shp);
        return this;
    }

    public PluginBuilder initTransactionPlugin() {
        TransactionProperties tp = this.hbatisProperties.getTransactionProperties();
        GLog.debug("TransactionIsolationPlugin inited.", new Object[0]);
        int levelInt = tp.getLevel();
        TransactionIsolationPlugin plugin = new TransactionIsolationPlugin(levelInt);
        this.pluginList.add(plugin);
        return this;
    }

    public PluginBuilder initDebugPlugin() {
        DebugPlugin debugPlugin = new DebugPlugin();
        debugPlugin.setDebug(this.hbatisProperties.isDebug());
        this.pluginList.add(debugPlugin);
        return this;
    }

    public PluginBuilder initOptimisticLockPlugin() {
        OptimisticLockPlugin optimisticLockPlugin = new OptimisticLockPlugin();
        optimisticLockPlugin.setEnableOptimisticLock(this.hbatisProperties.isOptimisticLockEnable());
        this.pluginList.add(optimisticLockPlugin);
        return this;
    }

    public PluginBuilder initCachePlugin() {
        CacheProperties cp = this.hbatisProperties.getCacheProperties();
        boolean useCache = cp.isInited();
        if (!useCache) {
            return this;
        }
        boolean isClassExist = ClassUtil.isClassExist("com.google.common.cache.CacheBuilder");
        if (!isClassExist) {
            GLog.error("guava\u4f9d\u8d56\u5e93\u6ca1\u6709\u52a0\u8f7d\uff0c\u7f13\u5b58\u63d2\u4ef6\u65e0\u6cd5\u521d\u59cb\u5316", new Object[0]);
            return this;
        }
        long expireLong = cp.getExpire();
        long maxSizeLong = cp.getMaxSize();
        GuavaCacheConfig gcc = new GuavaCacheConfig();
        gcc.setExpireAfterWrite(expireLong);
        gcc.setMaximumSize(maxSizeLong);
        GLog.debug("cache config, expireAfterWrite:{}, maximumSize:{}", expireLong, maxSizeLong);
        this.pluginList.add(new GuavaCachePlugin(gcc));
        return this;
    }

    public PluginBuilder initProxyPlugin() {
        String[] clzArray;
        ProxyProperties pp = this.hbatisProperties.getProxyProperties();
        String clzList = pp.getClazz();
        if (StrKit.isBlank(clzList)) {
            return this;
        }
        ProxyPlugin plugin = new ProxyPlugin();
        for (String clz : clzArray = clzList.split(",")) {
            if (!StrKit.isNotBlank(clz)) continue;
            IPlugin item = null;
            try {
                item = (IPlugin)Class.forName(clz.trim()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                GLog.error("\u521d\u59cb\u5316\u63d2\u4ef6\u5931\u8d25, clz: " + clz, e);
            }
            if (item == null) continue;
            plugin.addPlugin(item);
        }
        this.pluginList.add(plugin);
        return this;
    }

    private DataSourceWrapper buildDataSource(Map<String, Object> dsMap, Map<String, Object> extConfig) {
        return DataSourceWrapperFactory.buildDataSource(dsMap, extConfig);
    }

    public PluginBuilder initDataSourcePlugin() {
        DataSourcePlugin p = new DataSourcePlugin();
        DataSourceWrapper defaultDataSource = null;
        if (this.dataSource != null) {
            ExistDatasourceProperties edp = this.hbatisProperties.getExistDatasourceProperties();
            String dbtype = edp.getDbtype();
            defaultDataSource = DataSourceWrapper.create(this.dataSource, DbType.getDbType(dbtype));
        } else {
            DefaultDatasourceProperties ddp = this.hbatisProperties.getDefaultDatasource();
            HashMap<String, Object> dsMap = new HashMap<String, Object>();
            dsMap.put("url", ddp.getUrl());
            dsMap.put("driver", ddp.getDriver());
            dsMap.put("username", ddp.getUsername());
            dsMap.put("password", ddp.getPassword());
            dsMap.put("dbtype", ddp.getDbtype());
            dsMap.put("pooltype", ddp.getPooltype());
            DatasourcePoolProperties extConfig = ddp.getConfig();
            defaultDataSource = this.buildDataSource(dsMap, extConfig);
        }
        p.setDataSourceWrapper(defaultDataSource);
        this.pluginList.add(p);
        MultiDatasourceProperties mdp = this.hbatisProperties.getMultiDatasource();
        if (mdp == null || mdp.isEmpty()) {
            return this;
        }
        Set entrySets = mdp.entrySet();
        for (Map.Entry entry : entrySets) {
            SingleDatasourceProperties entrySdp = (SingleDatasourceProperties)entry.getValue();
            HashMap<String, Object> dsMapMulti = new HashMap<String, Object>();
            dsMapMulti.put("url", entrySdp.getUrl());
            dsMapMulti.put("driver", entrySdp.getDriver());
            dsMapMulti.put("username", entrySdp.getUsername());
            dsMapMulti.put("password", entrySdp.getPassword());
            dsMapMulti.put("dbtype", entrySdp.getDbtype());
            dsMapMulti.put("pooltype", entrySdp.getPooltype());
            DatasourcePoolProperties extConfigMulti = ((SingleDatasourceProperties)entry.getValue()).getConfig();
            DataSourceWrapper ds = this.buildDataSource(dsMapMulti, extConfigMulti);
            DataSourcePlugin ptmp = new DataSourcePlugin();
            ptmp.setJdbcResourceName((String)entry.getKey());
            ptmp.setDataSourceWrapper(ds);
            this.pluginList.add(ptmp);
        }
        return this;
    }

    public List<IPlugin> build() {
        return this.pluginList;
    }
}

