/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.starter.springboot;

import cn.sylinx.hbatis.ext.proxy.annotation.Command;
import cn.sylinx.hbatis.ext.starter.springboot.ClassPathCommandScanner;
import cn.sylinx.hbatis.ext.starter.springboot.PluginBuilder;
import cn.sylinx.hbatis.ext.starter.springboot.config.CacheProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.DefaultDatasourceProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.ExistDatasourceProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.HbatisProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.ModelpreloadProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.MultiDatasourceProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.ProxyProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.SqlResourcePreloadProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.StatementHandlerProperties;
import cn.sylinx.hbatis.ext.starter.springboot.config.TransactionProperties;
import cn.sylinx.hbatis.ext.starter.util.DefaultSimpleDaoService;
import cn.sylinx.hbatis.ext.starter.util.SimpleDaoService;
import cn.sylinx.hbatis.ext.transaction.springboot.TransactionAspect;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.IPlugin;
import cn.sylinx.hbatis.plugin.PluginStarter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

@Configuration
@Import(value={AutoConfiguredCommandScannerRegistrar.class, TransactionAspect.class})
public class HbatisAutoConfig {
    @Bean
    public PluginStarter pluginStarter(@Autowired(required=false) DataSource dataSource, HbatisProperties hbatisProperties) {
        return this.create(hbatisProperties, dataSource);
    }

    private PluginStarter create(HbatisProperties hbatisProperties, DataSource dataSource) {
        List<IPlugin> pluginList = hbatisProperties.isInit() ? new PluginBuilder(hbatisProperties, dataSource).initDataSourcePlugin().initModelPreLoadPlugin().initSqlResourcePreloadPlugin().initStatementHandlerPlugin().initTransactionPlugin().initCachePlugin().initDebugPlugin().initOptimisticLockPlugin().initProxyPlugin().build() : Collections.emptyList();
        PluginStarter pluginStarter = new PluginStarter(pluginList);
        pluginStarter.start();
        return pluginStarter;
    }

    @Bean
    public SimpleDaoService simpleDaoService() {
        return new DefaultSimpleDaoService();
    }

    @Bean
    public HbatisProperties hbatisProperties(ExistDatasourceProperties existDatasourceProperties, DefaultDatasourceProperties defaultDatasourceProperties, MultiDatasourceProperties multiDatasourceProperties, SqlResourcePreloadProperties sqlResourcePreloadProperties, ModelpreloadProperties modelpreloadProperties, TransactionProperties transactionProperties, CacheProperties cacheProperties, StatementHandlerProperties statementHandlerProperties, ProxyProperties proxyProperties, Environment env) {
        GLog.debug("ExistDatasourceProperties:{}", existDatasourceProperties);
        GLog.debug("DefaultDatasourceProperties:{}", defaultDatasourceProperties);
        GLog.debug("MultiDatasourceProperties:{}", multiDatasourceProperties);
        GLog.debug("SqlResourcePreloadProperties:{}", sqlResourcePreloadProperties);
        GLog.debug("ModelpreloadProperties:{}", modelpreloadProperties);
        GLog.debug("TransactionProperties:{}", transactionProperties);
        GLog.debug("CacheProperties:{}", cacheProperties);
        GLog.debug("ProxyProperties:{}", proxyProperties);
        GLog.debug("StatementHandlerProperties:{}", statementHandlerProperties);
        HbatisProperties hp = new HbatisProperties();
        hp.setCacheProperties(cacheProperties);
        hp.setDefaultDatasource(defaultDatasourceProperties);
        hp.setInit((Boolean)env.getProperty("hbatis.init", Boolean.TYPE, (Object)false));
        hp.setDebug((Boolean)env.getProperty("hbatis.debug", Boolean.TYPE, (Object)false));
        hp.setOptimisticLockEnable((Boolean)env.getProperty("hbatis.optimistic-lock.enable", Boolean.TYPE, (Object)false));
        hp.setModelpreloadProperties(modelpreloadProperties);
        hp.setMultiDatasource(multiDatasourceProperties);
        hp.setProxyProperties(proxyProperties);
        hp.setScanCommandPackages((String)env.getProperty("hbatis.command.scanpackage", String.class));
        hp.setSqlResourcePreloadProperties(sqlResourcePreloadProperties);
        hp.setTransactionProperties(transactionProperties);
        hp.setExistDatasourceProperties(existDatasourceProperties);
        hp.setStatementHandlerProperties(statementHandlerProperties);
        return hp;
    }

    @Bean
    @ConfigurationProperties(prefix="hbatis.plugin.cache")
    public CacheProperties getCacheProperties() {
        return new CacheProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hbatis.plugin.transaction")
    public TransactionProperties transactionProperties() {
        return new TransactionProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hbatis.plugin.modelpreload")
    public ModelpreloadProperties modelpreloadProperties() {
        return new ModelpreloadProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hbatis.plugin.resource")
    public SqlResourcePreloadProperties sqlResourcePreloadProperties() {
        return new SqlResourcePreloadProperties();
    }

    @Bean
    public ProxyProperties ProxyProperties(Environment env) {
        String clazz = env.getProperty("hbatis.plugin.proxy.class");
        ProxyProperties pp = new ProxyProperties();
        pp.setClazz(clazz);
        return pp;
    }

    @Bean
    @ConfigurationProperties(prefix="hbatis.datasource.default")
    public DefaultDatasourceProperties defaultDatasourceProperties() {
        return new DefaultDatasourceProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hbatis.datasource.multi", ignoreInvalidFields=true)
    public MultiDatasourceProperties multiDatasourceProperties() {
        return new MultiDatasourceProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hbatis.ds")
    public ExistDatasourceProperties existDatasourceProperties() {
        return new ExistDatasourceProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hbatis.plugin.statement")
    public StatementHandlerProperties statementHandlerProperties() {
        return new StatementHandlerProperties();
    }

    public static class AutoConfiguredCommandScannerRegistrar
    implements BeanFactoryAware,
    ImportBeanDefinitionRegistrar,
    ResourceLoaderAware {
        private BeanFactory beanFactory;
        private ResourceLoader resourceLoader;

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            GLog.debug("Searching for command annotated with @Command", new Object[0]);
            ClassPathCommandScanner scanner = new ClassPathCommandScanner(registry);
            try {
                if (this.resourceLoader != null) {
                    scanner.setResourceLoader(this.resourceLoader);
                }
                List packages = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
                scanner.setAnnotationClass(Command.class);
                scanner.registerFilters();
                scanner.doScan(StringUtils.toStringArray((Collection)packages));
            }
            catch (IllegalStateException ex) {
                GLog.debug("Could not determine auto-configuration package, automatic command scanning disabled.", ex);
            }
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }

        public void setResourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }
    }
}

